package com.rapid.j2ee.framework.orm.mybatis.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.aop.CGlibProxyFactory;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.io.xml.XPathParser;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.ResourceUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class MybatisInstantiationMapperPostProcessor extends
		InstantiationAwareBeanPostProcessorAdapter {

	private List<Class> mybatisClassMappers;

	@Override
	public Object postProcessAfterInitialization(Object bean, String beanName)
			throws BeansException {

		this.prepareMybatisClassMappers();

		if (this.isMybatisMapperInstantiation(bean)) {
			// do Aop Bean
			
			

			return CGlibProxyFactory.proxy(getMybatisMapperClass(bean),
					new MybatisMapperMethodInterceptor(bean));

		}

		return bean;

	}

	private boolean isMybatisMapperInstantiation(Object bean) {

		for (Class clz : mybatisClassMappers) {
			if (clz.isAssignableFrom(bean.getClass())) {
				return true;
			}
		}

		return false;

	}

	private Class getMybatisMapperClass(Object bean) {

		for (Class clz : mybatisClassMappers) {
			if (clz.isAssignableFrom(bean.getClass())) {
				return clz;
			}
		}

		return null;

	}

	private void prepareMybatisClassMappers() {

		if (!TypeChecker.isNull(mybatisClassMappers)) {
			return;
		}

		mybatisClassMappers = new ArrayList<Class>();

		Assert.noNullElements(locations,
				"Please provide mybatis mapper xml locations");

		try {
			
			System.out.println("test1...");
			this.parseMybatisMapperXmlConfigurers();
			System.out.println("tes2t...");
		} catch (IOException e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}

	}

	private void parseMybatisMapperXmlConfigurers() throws IOException {

		System.out.println(Arrays.asList(locations));

		Resource[] mybatisMapperXmlLocations = ResourceUtils
				.getResources(locations);

		for (Resource resource : mybatisMapperXmlLocations) {
			XPathParser xmlParser = new XPathParser(resource.getInputStream());
			mybatisClassMappers.add(ClassUtils.forName(xmlParser.evalNode(
					"mapper").getStringAttribute("namespace")));
		}

	}

	public void setLocation(String location) {
		locations = new String[] { location };
	}

	public void setLocations(String[] locations) {
		this.locations = locations;
	}

	private String[] locations;

}
