package com.rapid.j2ee.framework.orm.mybatis.mapper;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class MybatisMapperMethodInterceptor implements MethodInterceptor {

	private Object targetBean;

	public MybatisMapperMethodInterceptor(Object targetBean) {
		this.targetBean = targetBean;
	}

	public Object intercept(Object bean, Method method, Object[] parameters,
			MethodProxy methodProxy) throws Throwable {

		Object returnVal = methodProxy.invoke(targetBean, parameters);

		if (!this.isSingleMapAsParameters(method.getParameterTypes())) {
			return returnVal;
		}

		if (!this.isListReturnType(method.getReturnType())) {
			return returnVal;
		}

		this.saveMybatisMapperListReturn((List) returnVal);

		return returnVal;
	}

	private void saveMybatisMapperListReturn(List returnValList) {

		if (TypeChecker.isEmpty(returnValList)) {
			return;
		}

		if (!(returnValList.get(0) instanceof List)) {

			List rs = new ArrayList(1);
			rs.add(returnValList);

			MybatisMapperListReturnActionContext.setMybaitsMapperListReturn(rs);

			return;
		}

		MybatisMapperListReturnActionContext
				.setMybaitsMapperListReturn(returnValList);

	}

	private boolean isListReturnType(Class returnType) {
		return List.class.isAssignableFrom(returnType);
	}

	private boolean isSingleMapAsParameters(Class[] parameterClasses) {

		if (TypeChecker.isEmpty(parameterClasses)) {
			return false;
		}

		if (parameterClasses.length != 1) {
			return false;
		}

		return Map.class.isAssignableFrom(parameterClasses[0]);
	}

}
