package com.rapid.j2ee.framework.orm.mybatis.pagination;

import com.rapid.j2ee.framework.core.io.xml.XmlFieldAttribute;
import com.rapid.j2ee.framework.core.io.xml.XmlMethodAttribute;
import com.rapid.j2ee.framework.core.io.xml.XmlTag;
import com.rapid.j2ee.framework.core.pagination.PageInfo;
import com.rapid.j2ee.framework.orm.mybatis.criteria.AbstractMybatisSearchPageCriteria;

@XmlTag(tagName="PageInfo")
public class PageInfoBean implements PageInfo {
	
	@XmlFieldAttribute
	private Integer currentPage = 0;
	@XmlFieldAttribute
	private Integer pageSize = 0;
	@XmlFieldAttribute
	private Integer totalCounts = 0;

	public PageInfoBean(AbstractMybatisSearchPageCriteria outputResultContainer) {
		this.currentPage = outputResultContainer.getCurrentPage();
		this.pageSize = outputResultContainer.getPageSize();
		totalCounts = outputResultContainer.nextSingleOne(Integer.class);
	}

	public Integer getCurrentPage() {

		return currentPage;
	}

	public Integer getPageSize() {

		return pageSize;
	}

	@XmlMethodAttribute(tagAttributeName = "pageCounts")
	public Integer getPageCounts() {

		return this.totalCounts % pageSize == 0 ? this.totalCounts / pageSize
				: (this.totalCounts / pageSize) + 1;

	}

	public Integer getTotalCounts() {

		return totalCounts;
	}

	public boolean isEmptyRecords() {

		return this.totalCounts <= 0;
	}

}
