package com.rapid.j2ee.framework.orm.mybatis.pagination;

import java.util.List;

import com.rapid.j2ee.framework.core.io.xml.XmlFieldAttribute;
import com.rapid.j2ee.framework.core.io.xml.XmlTag;
import com.rapid.j2ee.framework.core.pagination.PageInfo;
import com.rapid.j2ee.framework.core.pagination.PageOutput;
import com.rapid.j2ee.framework.orm.mybatis.criteria.AbstractMybatisSearchPageCriteria;
import com.rapid.j2ee.framework.orm.mybatis.result.OutputResultContainer;

@XmlTag(tagName = "PageOutput")
public class PageOutputImpl implements PageOutput {

	@XmlFieldAttribute
	private PageInfo pageInfo;

	private OutputResultContainer outputResultContainer;

	@XmlFieldAttribute(tagAttributeName = "Result")
	private List result;

	@XmlFieldAttribute(tagAttributeName = "AddResult1")
	private List additionalResult;

	@XmlFieldAttribute(tagAttributeName = "AddResult2")
	private List additionalResult2;

	@XmlFieldAttribute(tagAttributeName = "AddResult3")
	private List additionalResult3;

	@XmlFieldAttribute(tagAttributeName = "AddResult4")
	private List additionalResult4;

	public PageOutputImpl(
			AbstractMybatisSearchPageCriteria outputResultContainer) {

		pageInfo = new PageInfoBean(outputResultContainer);

		this.outputResultContainer = outputResultContainer;

		result = outputResultContainer.nextVoidNullList(Object.class);

		additionalResult = outputResultContainer.nextVoidNullList(Object.class);

		additionalResult2 = outputResultContainer
				.nextVoidNullList(Object.class);

		additionalResult3 = outputResultContainer
				.nextVoidNullList(Object.class);

		additionalResult4 = outputResultContainer
				.nextVoidNullList(Object.class);

	}

	public PageInfo getPageInfo() {

		return pageInfo;
	}

	public boolean isEmpty() {

		return pageInfo.isEmptyRecords();
	}

	public List getResult() {

		return result;
	}

	public List getAdditionalResult() {

		return this.additionalResult;
	}

	public List getAdditionalResult2() {

		return this.additionalResult2;
	}

	public List getAdditionalResult3() {

		return this.additionalResult3;
	}

	public List getAdditionalResult4() {

		return this.additionalResult4;
	}

}
