package com.rapid.j2ee.framework.orm.mybatis.pagination;

import com.rapid.j2ee.framework.core.pagination.Page;
import com.rapid.j2ee.framework.core.pagination.PageBound;
import com.rapid.j2ee.framework.core.pagination.PageConstants;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.orm.mybatis.result.OutputResultMapContainer;

public class PageResultContainer extends OutputResultMapContainer implements
		Page, PageBound {

	private Integer currentPage;

	private Integer pageSize;

	public void setCurrentPage(Integer currentPage) {
		this.currentPage = currentPage;
	}

	public void setPageSize(Integer pageSize) {
		this.pageSize = pageSize;
	}

	public Integer getCurrentPage() {

		if (TypeChecker.isNull(currentPage) || currentPage == 0) {
			return 1;
		}

		return currentPage;
	}

	public Integer getPageSize() {

		if (TypeChecker.isNull(pageSize)) {
			return PageConstants.Page_Size_Default_Value;
		}

		return pageSize;
	}

	public Integer getBeginRow() {

		return (this.getCurrentPage() - 1) * this.getPageSize() + 1;
	}

	public Integer getEndRow() {

		return this.getCurrentPage() * this.getPageSize();
	}

	public boolean isNewQuery() {

		return TypeChecker.isNull(this.currentPage) || this.currentPage == 0;
	}

}
