package com.rapid.j2ee.framework.orm.mybatis.pagination.intercept;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.format.Formatter;
import com.rapid.j2ee.framework.format.SQLFormatter;
import com.rapid.j2ee.framework.orm.mybatis.DatabaseTypeAware;

@Intercepts( {
		@Signature(type = Executor.class, method = "query", args = {
				MappedStatement.class, Object.class, RowBounds.class,
				ResultHandler.class }),

		@Signature(type = Executor.class, method = "update", args = {
				MappedStatement.class, Object.class }) })
public class DatabaseAwareInterceptor implements Interceptor {

	public Object intercept(Invocation invocation) throws Throwable {

		MappedStatement mappedStatement = (MappedStatement) invocation
				.getArgs()[0];

		Object parameterObject = (Object) invocation.getArgs()[1];

		String databaseType = mappedStatement.getConfiguration().getVariables()
				.getProperty("dialect");

		System.out.println("DatabaseAwareInterceptor called............");

		System.out.println("DatabaseAwareInterceptor parameterObject == "
				+ parameterObject);

		if (parameterObject instanceof DatabaseTypeAware) {

			Logger.info("Database Type Aware : " + databaseType + " For Bean");
			((DatabaseTypeAware) parameterObject).setDatabaseType(databaseType);

		} else if (parameterObject instanceof Map) {

			Logger.info("Database Type Aware : " + databaseType + " For Map");

			if (parameterObject == ObjectUtils.EMPTY_MAP
					|| parameterObject == ObjectUtils.EMPTY_SORTHASHMAP) {

				parameterObject = new HashMap();

				invocation.getArgs()[1] = parameterObject;

			}

			((Map) parameterObject).put("databaseType", databaseType);

			// MyBaties.Configurer.Database.SystemCurrentDate=NOW

			// MyBaties.Configurer
			setGeneralMybatiesMethodParameters(databaseType,
					(Map) parameterObject);

		}

		BoundSql boundSql = mappedStatement.getBoundSql(parameterObject);

		if (!PaginationInterceptor.isAutoPaginationRequired(boundSql)) {
			Logger
					.info("\n-------------------Mybaties SQL Begin----------------------------------------------------------------------");
			Logger.info("");
			Logger.info("SQL:" + SQL_Formatter.format(boundSql.getSql()));
			Logger.info("");
			Logger.info("SQL Parameter:\n\t" + boundSql.getParameterObject());
			Logger.info("");
			Logger
					.info("-------------------Mybaties SQL End  ----------------------------------------------------------------------\n");

		}

		return invocation.proceed();

	}

	private void setDatabaseNow(String databaseType, Map parameterObject) {

		if (StringUtils.equalsIgnoreCase(databaseType, "MYSQL")) {
			parameterObject.put("Database_Now", "NOW()");
			parameterObject.put("Database_SystemCurrentDate", "NOW");
			return;
		}

		if (StringUtils.equalsIgnoreCase(databaseType, "oracle")) {
			parameterObject.put("Database_Now", "SYSDATE");
			parameterObject.put("Database_SystemCurrentDate", "SYSDATE");
			return;
		}

		if (StringUtils.equalsIgnoreCase(databaseType, "MSSQL")) {
			parameterObject.put("Database_Now", "getdate()");
			parameterObject.put("Database_SystemCurrentDate", "getdate()");
			return;
		}

		throw new IllegalArgumentException("Unsupport mysql type ["
				+ databaseType + "] for Database Now Date!");

	}

	private void setGeneralMybatiesMethodParameters(String databaseType,
			Map parameters) {

		if (TypeChecker.isNull(parameters)) {
			return;
		}

		this.setDatabaseNow(databaseType, parameters);

		Logger
				.info("\n-------------------Set System Properties ----------------------------------------------------------------------");

		for (Object key : System.getProperties().keySet()) {

			if (StringUtils.trimToEmpty((String) key).startsWith(
					"MyBaties.Configurer.")) {

				String newKey = StringUtils.trimToEmpty((String) key)
						.substring("MyBaties.Configurer.".length());

				parameters.put(newKey, System.getProperty((String) key));

				System.out.println("New Key:" + newKey + " Value:"
						+ System.getProperty((String) key));
			}
		}
	}

	public Object plugin(Object target) {

		return Plugin.wrap(target, this);
	}

	public void setProperties(Properties properties) {

	}

	private static final Log Logger = LogFactory
			.getLog(DatabaseAwareInterceptor.class);

	private static Formatter SQL_Formatter = new SQLFormatter();

}
