package com.rapid.j2ee.framework.orm.mybatis.pagination.intercept;

import java.util.Map;

import org.springframework.stereotype.Component;

import com.rapid.j2ee.framework.orm.utils.SqlParserUtils;

@Component
public class GeneralSqlCountConverter implements SqlCountConverter {

	public String convert(String sql, Map parameter) {

		try {
			return SqlParserUtils.getCountSql(sql);
		} catch (Exception e) {
			return "SELECT COUNT(1) FROM ( " + sql + ") tmp";
		}
	}

	public String getMapperId() {

		return "Default";
	}



}
