package com.rapid.j2ee.framework.orm.mybatis.pagination.intercept;

import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;

import com.rapid.j2ee.framework.core.pagination.PageOutputContainer;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

@Intercepts(@Signature(type = StatementHandler.class, method = "query", args = {
		Statement.class, ResultHandler.class }))
public class MultipleResultSetInterceptor implements Interceptor {

	public Object intercept(Invocation invocation) throws Throwable {

		StatementHandler statmentHandler = (StatementHandler) invocation
				.getTarget();

		Object parameterObject = (Object) statmentHandler.getBoundSql()
				.getParameterObject();

		if (!(parameterObject instanceof Map)) {
			return invocation.proceed();
		}

		Map parameter = (Map) parameterObject;

		Object value = invocation.proceed();

		this.setMultipleReturnLists(parameter, value);

		return value;

	}

	private void setMultipleReturnLists(Map parameter, Object value) {

		if (TypeChecker.isNull(value)) {
			return;
		}

		if (!(value instanceof List)) {
			return;
		}

		List returnValList = (List) value;

		if (TypeChecker.isEmpty(returnValList)) {
			return;
		}

		if (!(returnValList.get(0) instanceof List)) {

			parameter.put(
					PageOutputContainer.OUTPUT_CURSOR_KEY + "_ResultSet1",
					returnValList);

			return;
		}

		int index = 1;

		for (Object item : returnValList) {
			parameter.put(PageOutputContainer.OUTPUT_CURSOR_KEY + "_ResultSet"
					+ (index++), item);
		}

	}

	public Object plugin(Object target) {

		return Plugin.wrap(target, this);
	}

	public void setProperties(Properties properties) {
		
	}

	private static final Log Logger = LogFactory
			.getLog(PaginationInterceptor.class);

}
