package com.rapid.j2ee.framework.orm.mybatis.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import org.apache.ibatis.reflection.factory.DefaultObjectFactory;

import com.rapid.j2ee.framework.core.utils.NumberUtils;

public class DefaultObjectSetCapacityFactory extends DefaultObjectFactory {

	private static final long serialVersionUID = 2362940069020417757L;

	private Properties properties;

	private static List LIST_CONSTRUCTION_PARAM_CLZ = new ArrayList(1);

	static {
		LIST_CONSTRUCTION_PARAM_CLZ.add(int.class);
	}

	public DefaultObjectSetCapacityFactory() {
		properties = new Properties();
	}

	public <T> T create(Class<T> type) {

		if (type == List.class) {

			List param = new ArrayList(1);

			param.add(getPropertyIntValue("List_Capacity"));

			return (T) super.create(type, LIST_CONSTRUCTION_PARAM_CLZ, param);
		}

		return super.create(type, null, null);
	}

	public void setProperties(Properties properties) {
		this.properties = properties;
	}

	public int getPropertyIntValue(String key) {

		if (!properties.containsKey(key)) {
			return LIST_CAPACITY_SIZE;
		}

		return NumberUtils.parseInt(properties.getProperty(key),
				LIST_CAPACITY_SIZE);
	}

	private static final int LIST_CAPACITY_SIZE = 10;

}
