package com.rapid.j2ee.framework.orm.mybatis.plugin;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

import com.rapid.j2ee.framework.core.utils.StringUtils;

public class StringNullToEmptyTypeHandler extends BaseTypeHandler<String> {

	public String getResult(ResultSet rs, String columnName)
			throws SQLException {

		return getNullableResult(rs, columnName);

	}

	public String getResult(ResultSet rs, int columnIndex) throws SQLException {
		return getNullableResult(rs, columnIndex);

	}

	public String getResult(CallableStatement cs, int columnIndex)
			throws SQLException {
		return getNullableResult(cs, columnIndex);

	}

	@Override
	public String getNullableResult(ResultSet rs, String columnName)
			throws SQLException {

		return StringUtils.trimToEmpty(rs.getString(columnName));
	}

	@Override
	public String getNullableResult(ResultSet rs, int columnIndex)
			throws SQLException {

		return StringUtils.trimToEmpty(rs.getString(columnIndex));
	}

	@Override
	public String getNullableResult(CallableStatement cs, int columnIndex)
			throws SQLException {

		return StringUtils.trimToEmpty(cs.getString(columnIndex));
	}

	@Override
	public void setNonNullParameter(PreparedStatement ps, int i,
			String parameter, JdbcType jdbcType) throws SQLException {

		ps.setString(i, StringUtils.trimToEmpty(parameter));

	}

}
