package com.rapid.j2ee.framework.orm.mybatis.result;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.orm.mybatis.mapper.MybatisMapperListReturnActionContext;

public class OutputResultMapContainer implements OutputResultContainer {

	private Map<String, Object> containers = Collections.EMPTY_MAP;

	protected List outputResultList = null;

	private Log logger = LogFactory.getLog(OutputResultMapContainer.class);

	private int currentIndex;

	public void prepare(Map<String, Object> parameter) {

		Assert.notEmpty(parameter);

		containers = parameter;

	}

	private List<String> getOutputResultKeys() {

		List<String> keys = new ArrayList(2);

		for (Iterator<String> it = containers.keySet().iterator(); it.hasNext();) {
			String key = it.next();

			if (this.isOutputParameter(key)) {
				keys.add(key);
			}
		}

		List<String> cursorKeys = new ArrayList(4);

		for (Iterator<String> it = containers.keySet().iterator(); it.hasNext();) {
			String key = it.next();

			if (this.isOutputCursor(key)) {
				cursorKeys.add(key);
			}
		}

		Collections.sort(cursorKeys);

		keys.addAll(cursorKeys);

		logger.info("The Container ResultSet's Keys :" + keys + " At "
				+ this.getClass().getName());

		return keys;

	}

	protected void retrieveOutputResults() {

		if (!TypeChecker.isNull(outputResultList)) {
			return;
		}

		outputResultList = new ArrayList(5);

		for (Iterator<String> it = getOutputResultKeys().iterator(); it
				.hasNext();) {

			String key = it.next();

			Object rs = containers.get(key);

			outputResultList.add(rs);
		}

		if (!TypeChecker.isEmpty(MybatisMapperListReturnActionContext
				.getMybaitsMapperListReturn())) {

			for (List item : MybatisMapperListReturnActionContext
					.getMybaitsMapperListReturn()) {

				outputResultList.add(item);

			}
		}

		Assert.notEmpty(outputResultList, "Sorry, cannot find any items !");

	}

	private boolean isOutputCursor(String key) {
		return StringUtils.startsWithIgnoreCase(key, OUTPUT_CURSOR_KEY);
	}

	private boolean isOutputParameter(String key) {
		return StringUtils.startsWithIgnoreCase(key, OUTPUT_PARAMETER_KEY);
	}

	public Object next() {

		this.retrieveOutputResults();

		if (this.currentIndex >= outputResultList.size()) {
			return null;
		}

		return this.outputResultList.get(this.currentIndex++);
	}

	public <T> T next(Class<T> clz) {

		return (T) this.next();
	}

	public <T> List<T> nextList(Class<T> requiredType) {

		return (List<T>) next();
	}

	public <T> List<T> nextVoidNullList(Class<T> requiredType) {

		List<T> result = nextList(requiredType);

		return TypeChecker.isNull(result) ? ObjectUtils.EMPTY_LIST : result;
	}

	public <T> T nextSingleOne(Class<T> requiredType) {

		Object item = next();

		if (item instanceof List) {

			List list = (List) item;

			return TypeChecker.isEmpty(list) ? null : (T) list.get(0);
		}

		return (T) item;
	}

	public void reset() {
		outputResultList = null;
		currentIndex = 0;
	}

}
