package com.rapid.j2ee.framework.orm.pkg;

public class PrimaryKeyGenerator {

	private PrimaryKeyJdbcGenerator jdbcTemplate;

	private String tableName;

	private long currentPrimarykeyVal;

	private long maxPrimarykeyNextVal;

	private String param;

	private int step;

	public PrimaryKeyGenerator(PrimaryKeyJdbcGenerator jdbcTemplate,
			String tableName, String param, int step) {
		this.jdbcTemplate = jdbcTemplate;
		this.tableName = tableName;
		this.param = param;
		currentPrimarykeyVal = 0;
		maxPrimarykeyNextVal = -1;
		this.step = step;

	}

	public long nextPrimarykeyVal() {

		if (currentPrimarykeyVal > maxPrimarykeyNextVal) {

			long keyFromDB = jdbcTemplate.getPrimaryKeyNextVal(tableName,
					param, step);

			maxPrimarykeyNextVal = keyFromDB;

			this.currentPrimarykeyVal = keyFromDB - this.step + 1;

		}

		return currentPrimarykeyVal++;

	}

	public void restoreReservedPrimarykey() {

		jdbcTemplate.restoreReservedPrimarykey(tableName, param, Math.max(
				currentPrimarykeyVal, 1) - 1, step);
	}

}
