package com.rapid.j2ee.framework.orm.pkg;

import java.util.HashMap;
import java.util.Map;

import javax.sql.DataSource;

import com.rapid.j2ee.framework.core.utils.StringUtils;

public class PrimaryKeyGeneratorPool {

	public PrimaryKeyGeneratorPool() {
		this.container = new HashMap<String, PrimaryKeyGenerator>(20);
		this.step = DEFAULT_PRIMARYKEY_STEP;
		primaryKeyTableName = PRIMARYKEY_PERSISTENCE_TABLENAME;
	}

	public void setDataSource(DataSource dataSource) {
		this.dataSource = dataSource;
	}

	public void setPrimaryKeyTableName(String primaryKeyTableName) {
		this.primaryKeyTableName = primaryKeyTableName;
	}

	public void setStep(int step) {
		this.step = step;
	}

	public synchronized void close() {
		for (PrimaryKeyGenerator pkg : container.values()) {
			pkg.restoreReservedPrimarykey();
		}
	}

	public synchronized long nextPrimarykeyNextVal(String tableName,
			String param) {

		return PrimaryKeyGeneratorPoolHelper.getCachedPrimarykeyGenerator(
				container, primaryKeyTableName, dataSource, tableName,
				StringUtils.trimToEmpty(param, emptyParamDefaultValue), step,
				updateSeqNoFuncName).nextPrimarykeyVal();
	}

	public long nextPrimarykeyNextVal(String tableName) {
		return nextPrimarykeyNextVal(tableName, emptyParamDefaultValue);
	}

	public String nextPrimarykeyByFormat(String tableName, String format) {
		return nextPrimarykeyByFormat(tableName, emptyParamDefaultValue, format);
	}

	public String nextPrimarykeyByFormat(String tableName, String param,
			String format) {

		return PrimaryKeyGeneratorPoolHelper
				.nextPrimarykeyRepeatByFormat(
						this.nextPrimarykeyNextVal(tableName, param),
						format,
						PrimaryKeyGeneratorPoolHelper.UNREPEAT_SEED_EXCEEDDIGITALFORMAT_CALLBACK);
	}

	public String nextPrimarykeyRepeatByFormat(String tableName, String format) {
		return nextPrimarykeyRepeatByFormat(tableName, emptyParamDefaultValue,
				format);
	}

	public String nextPrimarykeyRepeatByFormat(String tableName, String param,
			String format) {

		return PrimaryKeyGeneratorPoolHelper
				.nextPrimarykeyRepeatByFormat(
						this.nextPrimarykeyNextVal(tableName, param),
						format,
						PrimaryKeyGeneratorPoolHelper.REPEAT_SEED_EXCEEDDIGITALFORMAT_CALLBACK);
	}

	public void setEmptyParamDefaultValue(String emptyParamDefaultValue) {
		this.emptyParamDefaultValue = emptyParamDefaultValue;
	}

	public void setUpdateSeqNoFuncName(String updateSeqNoFuncName) {
		this.updateSeqNoFuncName = updateSeqNoFuncName;
	}

	private String primaryKeyTableName;

	private DataSource dataSource;

	private static final int DEFAULT_PRIMARYKEY_STEP = 20;

	private static final String PRIMARYKEY_PERSISTENCE_TABLENAME = "PK_GENERAL_GENERATOR";

	private int step;

	private Map<String, PrimaryKeyGenerator> container;

	private String updateSeqNoFuncName;

	private String emptyParamDefaultValue = "ALL";

}
