package com.rapid.j2ee.framework.orm.pkg;

import java.util.Map;

import javax.sql.DataSource;

import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.utils.StringUtils;

public class PrimaryKeyGeneratorPoolHelper {

	public static interface ExceedDigitalFormatCallback {

		public String doPrimaryKeyMiddleFormat(String middle, String value,
				int exceedDigitals);
	}

	static ExceedDigitalFormatCallback REPEAT_SEED_EXCEEDDIGITALFORMAT_CALLBACK = new ExceedDigitalFormatCallback() {

		public String doPrimaryKeyMiddleFormat(String middle, String value,
				int exceedDigitals) {

			return value.substring(exceedDigitals);
		}

	};

	static ExceedDigitalFormatCallback UNREPEAT_SEED_EXCEEDDIGITALFORMAT_CALLBACK = new ExceedDigitalFormatCallback() {

		public String doPrimaryKeyMiddleFormat(String middle, String value,
				int exceedDigitals) {

			return value;
		}

	};

	static String nextPrimarykeyRepeatByFormat(long nextPrimarykeyVal,
			String format, ExceedDigitalFormatCallback callback) {

		String[] smd = PrimaryKeyGeneratorPoolHelper
				.splitStartMidEndByBrackets(format);
		String nextVal = String.valueOf(nextPrimarykeyVal);

		int exceedDigitals = nextVal.length() - smd[1].length();

		if (exceedDigitals > 0) {
			return smd[0]
					+ callback.doPrimaryKeyMiddleFormat(smd[1], nextVal,
							exceedDigitals) + smd[2];
		}

		return smd[0] + smd[1].substring(0, smd[1].length() - nextVal.length())
				+ nextVal + smd[2];
	}

	static PrimaryKeyGenerator getCachedPrimarykeyGenerator(
			Map<String, PrimaryKeyGenerator> container,
			String primaryKeyTableName, DataSource dataSource,
			String tableName, String param, int step, String updateSeqSql) {

		String cachedKey = (tableName + "|" + param).toUpperCase();

		if (!container.containsKey(cachedKey)) {

			container.put(cachedKey, PrimaryKeyGeneratorPoolHelper
					.getPrimarykeyGenerator(primaryKeyTableName, dataSource,
							tableName, param, step, updateSeqSql));

		}

		return container.get(cachedKey);

	}

	static String[] splitStartMidEndByBrackets(String format) {

		format = StringUtils.trimToEmpty(format);

		String[] startMidEnd = StringUtils.splitClosure(format, "{", "}");

		Assert.isTrue(startMidEnd.length == 1, "The format must be a{xxx}b");

		startMidEnd = new String[] { StringUtils.substringBefore(format, "{"),
				startMidEnd[0], StringUtils.substringAfterLast(format, "}") };

		return startMidEnd;

	}

	private static PrimaryKeyGenerator getPrimarykeyGenerator(
			String primaryKeyTableName, DataSource dataSource,
			String tableName, String param, int step, String updateSeqFuncSql) {

		return new PrimaryKeyGenerator(new PrimaryKeyJdbcGenerator(dataSource,
				primaryKeyTableName, updateSeqFuncSql), tableName, param, step);

	}

}
