package com.rapid.j2ee.framework.orm.utils;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

import org.hibernate.jdbc.util.BasicFormatterImpl;
import org.hibernate.jdbc.util.FormatStyle;

import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;

import com.rapid.j2ee.framework.core.annoconverter.converter.SqlLikeType;
import com.rapid.j2ee.framework.core.annoconverter.converter.SqlLikeType.LikeType;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class SqlParserUtils {

	public static String getSqlTableName(String sql)  {

		try {
			CCJSqlParserManager ccjManager = new CCJSqlParserManager();
			Select selectStatement = (Select) ccjManager
					.parse(new StringReader(sql));
			SelectBody selectBody = (SelectBody) selectStatement
					.getSelectBody();
			PlainSelect plainSelect = (PlainSelect) selectBody;
			String fromSql = plainSelect.getFromItem().toString();

			return StringUtils.substringBefore(fromSql, " AS ");

		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	public static String getCountSql(String sql) throws JSQLParserException {

		String sqlKey = sql.toLowerCase();

		synchronized (SqlToCountSqlMapper) {

			if (!SqlToCountSqlMapper.containsKey(sqlKey)) {
				SqlToCountSqlMapper.put(sqlKey, _getCountSql(sql));
			}

		}

		return SqlToCountSqlMapper.get(sqlKey);

	}

	private static String _getCountSql(String sql) throws JSQLParserException {

		if (sql.toLowerCase().indexOf("from") < 0) {
			return "SELECT 1";
		}

		CCJSqlParserManager ccjManager = new CCJSqlParserManager();

		Select selectStatement = (Select) ccjManager
				.parse(new StringReader(sql));

		SelectBody selectBody = (SelectBody) selectStatement.getSelectBody();

		if (!(selectBody instanceof PlainSelect)) {
			return "SELECT COUNT(1) FROM ( " + sql + ") tmp";
		}

		PlainSelect plainSelect = (PlainSelect) selectBody;

		if (plainSelect.getFromItem() == null) {
			return "SELECT COUNT(1) FROM ( " + sql + ") tmp";
		}

		String fromSql = plainSelect.getFromItem().toString();

		String joinSql = "";

		if (!TypeChecker.isEmpty(plainSelect.getJoins())) {

			for (Object temp : plainSelect.getJoins()) {
				Join join = (Join) temp;

				String tableJoin = " ,";

				if (join.isLeft() || join.isRight() || join.isInner()) {
					tableJoin = " ";
				}

				joinSql += tableJoin + join;
			}

			if (joinSql.endsWith(",")) {
				joinSql = joinSql.substring(0, joinSql.length() - 1);
			}

		}

		fromSql = StringUtils.replaceAll(fromSql + joinSql, " AS ", " ");

		if (plainSelect.getWhere() == null) {
			return "SELECT COUNT(1) FROM  " + fromSql;
		}

		return "SELECT COUNT(1) FROM  "
				+ fromSql
				+ " WHERE "
				+ StringUtils.replaceAll(plainSelect.getWhere().toString(),
						" AS ", " ");
	}

	public static String toLikeSqlValue(Object obj,
			SqlLikeType.LikeType likeType) {

		String value = StringUtils.trimToEmpty((String) obj);

		if (likeType == LikeType.Left) {
			return value + "%";
		}

		if (likeType == LikeType.Right) {
			return "%" + value;
		}

		if (likeType == LikeType.Both) {
			return "%" + value + "%";
		}

		return value;
	}

	private SqlParserUtils() {

	}

	public static void main(String[] args) throws JSQLParserException {

		System.out.println(SqlParserUtils
				.getSqlTableName("SELECT * from ct_notice_user where 1=1"));
	}

	private static Map<String, String> SqlToCountSqlMapper = new HashMap<String, String>();

}