package com.rapid.j2ee.framework.push;

import java.util.Properties;
import java.util.Set;

import com.rapid.j2ee.framework.core.utils.ObjectAnalyzer;
import com.rapid.j2ee.framework.core.utils.UUIDGenerator;

public abstract class AbstractNotification<T> implements Notification<T> {

	/**
	 * Notification Primary Key
	 */
	protected String notificationId;

	protected String tokenId;

	protected String message;

	protected Properties dictionaries;

	protected T source;

	public AbstractNotification(String tokenId) {

		this.notificationId = "Push_" + UUIDGenerator.nextUUID();

		this.tokenId = tokenId;

		dictionaries = new Properties();
	}

	public Properties getDictionaries() {
		return dictionaries;
	}

	public void putDictionaries(Properties dictionaries) {
		this.dictionaries.putAll(dictionaries);
	}

	public void addDictionary(String key, String value) {
		this.dictionaries.setProperty(key, value);
	}

	public Set<String> getPropertyKeys() {
		return (Set) getDictionaries().keySet();
	}

	public String getDictionaryValue(String key) {
		return this.getDictionaries().getProperty(key);
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public String getNotificationId() {
		return notificationId;
	}

	public String getTokenId() {
		return tokenId;
	}

	@Override
	public String toString() {
		return ObjectAnalyzer.toString(this);
	}

	public T getSource() {
		return source;
	}

	public void setSource(T source) {
		this.source = source;
	}

}
