package com.rapid.j2ee.framework.push;

import java.util.ArrayList;
import java.util.List;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.push.error.PushNotificationFailover;

public abstract class AbstractPushNotificationProvider<T> extends
		AbstractNotificationServerConfigurer implements
		PushNotificationProvider {

	public final void push(Notification notification) {
		List<Notification> notifications = new ArrayList<Notification>(1);
		notifications.add(notification);
		this.push(notifications);
	}

	public final void push(List<Notification> notifications) {

		if (TypeChecker.isEmpty(notifications)) {
			return;
		}

		T initObject = null;

		try {

			initObject = this.init();

			pushNotificationLifeCycleObserver.observeInitPushSuccess(this
					.getClass(), initObject);

			for (Notification notification : notifications) {

				if (!this.beforePush(notification)) {

					pushNotificationLifeCycleObserver
							.observeNotificationAbandonedPush(this.getClass(),
									notification);

					continue;
				}

				this.doPushWithErrorHandle(initObject, notification);

				this.afterPush(notification);
			}

		} catch (Throwable e) {

			pushNotificationLifeCycleObserver.observeInitPushFailed(this
					.getClass(), e);

			throw ExceptionUtils.convertThrowableToBaseException(e);
		} finally {
			this.close(initObject);
		}

	}

	private void doPushWithErrorHandle(T initObject, Notification notification) {
		try {

			this.doPush(initObject, notification);

			pushNotificationLifeCycleObserver.observeNotificationSuccessPush(
					this.getClass(), notification);

		} catch (Throwable e) {

			pushNotificationLifeCycleObserver.observeNotificationFailedPush(
					this.getClass(), notification,e);

			this.saveFailureNotification(notification, e);
		}
	}

	protected abstract void doPush(T initObject, Notification notification)
			throws Throwable;

	protected abstract void close(T initObject);

	protected void afterPush(Notification notification) {
		try {
			if (pushInterval > 0) {
				Thread.sleep(this.pushInterval);
			}
		} catch (Exception e) {

		}
	}

	protected boolean beforePush(Notification notification) {
		return true;
	}

	private void saveFailureNotification(Notification notification, Throwable e) {

		if (TypeChecker.isNull(pushNotificationFailover)) {
			return;
		}

		pushNotificationFailover.saveFailureNotification(this.getClass(),
				notification, e);

	}

	public void setPushNotificationFailover(
			PushNotificationFailover pushNotificationFailover) {
		this.pushNotificationFailover = pushNotificationFailover;
	}

	public void setPushNotificationLifeCycleObserver(
			PushNotificationLifeCycleObserver pushNotificationLifeCycleObserver) {
		this.pushNotificationLifeCycleObserver = pushNotificationLifeCycleObserver;
	}

	protected abstract T init() throws Throwable;

	private PushNotificationFailover pushNotificationFailover;

	private PushNotificationLifeCycleObserver pushNotificationLifeCycleObserver = PushNotificationLifeCycleObserver.Do_Nothing_Observer;
}
