package com.rapid.j2ee.framework.push;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.MultiHashMap;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.push.error.PushNotificationFailover;

public class PushNotificationProviderSelector implements InitializingBean {

	public void push(Notification notification) {

		this.selectPushNotificationProviderByType(notification.getClass())
				.push(notification);

	}

	public void push(List<Notification> notifications) {

		if (TypeChecker.isEmpty(notifications)) {
			return;
		}

		if (this.isOnlyOnePushNotificationProvider()) {

			this.doPushNotifications(this.pushNotificationProviders.get(0),
					notifications);

			return;
		}

		MultiHashMap notificationMultiMapTypes = this
				.getNotificationMultiMapByTypes(notifications);

		for (Object notificationType : notificationMultiMapTypes.keySet()) {

			this.selectPushNotificationProviderByType((Class) notificationType)
					.push(
							(List<Notification>) notificationMultiMapTypes
									.get(notificationType));
		}

	}

	private MultiHashMap getNotificationMultiMapByTypes(
			List<Notification> notifications) {

		MultiHashMap notificationMapTypes = new MultiHashMap();

		for (Notification notification : notifications) {
			notificationMapTypes.put(notification.getClass(), notification);
		}

		return notificationMapTypes;

	}

	private PushNotificationProvider selectPushNotificationProviderByType(
			Class notificationType) {

		Assert.isTrue(pushNotificationProviderMappers
				.containsKey(notificationType),
				"Please provide a PushNotificationProvider to handle "
						+ notificationType.getSimpleName() + "!");

		if (!TypeChecker.isEmpty(targetNotificationClassName)
				&& !notificationType.getName().endsWith(
						targetNotificationClassName)) {

			return PushNotificationProvider.DoNothing_PushNotificationProvider;

		}

		return pushNotificationProviderMappers.get(notificationType);
	}

	private void doPushNotifications(
			PushNotificationProvider pushNotificationProvider,
			List<Notification> notifications) {

		pushNotificationProvider.push(notifications);

	}

	public void afterPropertiesSet() throws Exception {

		System.out
				.println("---------Registry PushNotificationProviders---------");

		for (PushNotificationProvider pushNotificationProvider : pushNotificationProviders) {

			Assert.isTrue(pushNotificationProvider.getClass()
					.isAnnotationPresent(NotificationPushEvent.class),
					"Please provide notification push event on "
							+ pushNotificationProvider.getClass()
									.getSimpleName() + "!");

			if (pushNotificationProvider instanceof AbstractPushNotificationProvider) {
				((AbstractPushNotificationProvider) pushNotificationProvider)
						.setPushNotificationFailover(pushNotificationFailover);
			}

			pushNotificationProviderMappers.put(pushNotificationProvider
					.getClass().getAnnotation(NotificationPushEvent.class)
					.value(), pushNotificationProvider);

			System.out.println(pushNotificationProvider.getClass()
					.getAnnotation(NotificationPushEvent.class).value()
					+ " For " + pushNotificationProvider.getClass().getName());
		}

	}

	private boolean isOnlyOnePushNotificationProvider() {
		return pushNotificationProviders.size() == 1;
	}

	public void setPushNotificationFailover(
			PushNotificationFailover pushNotificationFailover) {
		this.pushNotificationFailover = pushNotificationFailover;
	}

	public void setTargetNotificationClassName(
			String targetNotificationClassName) {
		this.targetNotificationClassName = targetNotificationClassName;
	}

	@Autowired
	private List<PushNotificationProvider> pushNotificationProviders = new ArrayList<PushNotificationProvider>(
			5);

	private Map<Class, PushNotificationProvider> pushNotificationProviderMappers = new HashMap<Class, PushNotificationProvider>(
			5);

	private PushNotificationFailover pushNotificationFailover;

	private String targetNotificationClassName;

}
