package com.rapid.j2ee.framework.push.baidu;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.baidu.yun.channel.auth.ChannelKeyPair;
import com.baidu.yun.channel.client.BaiduChannelClient;
import com.baidu.yun.channel.model.PushUnicastMessageRequest;
import com.baidu.yun.channel.model.PushUnicastMessageResponse;
import com.rapid.j2ee.framework.core.utils.NumberUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.push.Notification;
import com.rapid.j2ee.framework.push.NotificationPushEvent;

@NotificationPushEvent(BaiduNotification.class)
public class BaiduAppPushNotificationProvider extends
		BaiduNotificationServerConfigurer<BaiduChannelClient> {

	@Override
	protected void close(BaiduChannelClient baiduChannelClient) {
		// do nothing...

	}

	@Override
	protected void doPush(BaiduChannelClient baiduChannelClient,
			Notification notification) throws Throwable {

		PushUnicastMessageRequest request = new PushUnicastMessageRequest();
		request.setDeviceType(3); // device_type => 1: web 2: pc 3:android
		// 4:ios 5:wp

		request.setChannelId(NumberUtils.parseLong(StringUtils.substringBefore(
				notification.getTokenId(), this.tokenIdSeparator)));
		request.setUserId(StringUtils.substringAfter(notification.getTokenId(),
				tokenIdSeparator));

		// 通知

		BaiduNotification baiduNotification = (BaiduNotification) notification;

		request.setMessageType(1);
		request.setMessage(baiduNotification.getNotificationJson());

		Logger
				.info("push message : "
						+ baiduNotification.getNotificationJson());

		PushUnicastMessageResponse response = baiduChannelClient
				.pushUnicastMessage(request);

		// 6. 认证推送成功
		Logger.info("push amount : " + response.getSuccessAmount());
	}

	@Override
	protected BaiduChannelClient init() throws Throwable {

		return new BaiduChannelClient(new ChannelKeyPair(this.apiKey,
				this.secretKey));
	}

	private static final Log Logger = LogFactory
			.getLog(BaiduAppPushNotificationProvider.class);

}
