package com.rapid.j2ee.framework.push.baidu;

import java.util.HashMap;
import java.util.Map;

import net.sf.json.JSONObject;

import com.rapid.j2ee.framework.core.io.json.JsonUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.push.AbstractNotification;

public class BaiduNotification<T> extends AbstractNotification<T> {

	private String title;

	/**
	 * Android客户端自定义通知样式，如果没有设置默认为0;(具体使用方法参照管理控制台页面)
	 */
	private int notificationBuilderId = 0;

	/**
	 * notification_basic_style:只有notification_builder_id为0时才有效，才需要设置；该属性是整型，每一位代表一种基本样式，基本样式用二进制位表示如下
	 * 响铃：0100B=0x04 振动：0010B=0x02 可清除：0001B=0x01
	 * 如果需要同时设置多种基本样式，可以对上述三种基本样式做“或”运算，例如要设置通知为响铃、振动和可清除、则notification_basic_style
	 * 值为： notification_basic_style=0100B | 0010B | 0001B= 0111B=0x07
	 */
	private int notificationBasicStyle = 0x07;

	/**
	 * 点击通知后的行为 1: 表示打开Url 2: 表示打开应用 i.如果pkg_content有定义，则按照自定义行为打开应用
	 * ii.如果pkg_content无定义，则启动app的launcher activity
	 */
	private int openType = 2;

	private String url;

	/**
	 * 只有open_type为1时才有效 1: 表示打开url地址时需要经过用户允许 0：默认值，表示直接打开url地址不需要用户允许
	 */
	private String userConfirm;

	/**
	 * 只有open_type为2时才有效, Android端SDK会把pkg_content字符串转换成Android
	 * Intent,通过该Intent打开对应app组件，所以pkg_content字符串格式必须遵循Intent
	 * uri格式，最简单的方法可以通过Intent方法toURI()获取
	 */
	private String pkgContent;

	public BaiduNotification(String tokenId) {
		super(tokenId);

	}

	public String getNotificationJson() {

		Map notification = new HashMap();

		notification.put("title", this.title);
		notification.put("description", this.message);
		notification.put("notification_builder_id", this.notificationBuilderId);
		notification.put("notification_basic_style",
				this.notificationBasicStyle);
		notification.put("open_type", this.openType);

		if (!TypeChecker.isEmpty(this.url)) {
			notification.put("url", this.url);
		}

		if (!TypeChecker.isEmpty(this.userConfirm)) {
			notification.put("user_confirm", this.userConfirm);
		}

		if (!TypeChecker.isEmpty(this.pkgContent)) {
			notification.put("pkg_content", this.pkgContent);
		}

		if (!TypeChecker.isEmpty(this.dictionaries)) {
			notification.put("custom_content", this.dictionaries);
		}

		return JsonUtils.formatJsonText(notification);
	}

	public int getNotificationBasicStyle() {
		return notificationBasicStyle;
	}

	public void setNotificationBasicStyle(int notificationBasicStyle) {
		this.notificationBasicStyle = notificationBasicStyle;
	}

	public int getNotificationBuilderId() {
		return notificationBuilderId;
	}

	public void setNotificationBuilderId(int notificationBuilderId) {
		this.notificationBuilderId = notificationBuilderId;
	}

	public int getOpenType() {
		return openType;
	}

	public void setOpenType(int openType) {
		this.openType = openType;
	}

	public String getPkgContent() {
		return pkgContent;
	}

	public void setPkgContent(String pkgContent) {
		this.pkgContent = pkgContent;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getUserConfirm() {
		return userConfirm;
	}

	public void setUserConfirm(String userConfirm) {
		this.userConfirm = userConfirm;
	}

	public static void main(String[] args) {

		Map notification = new HashMap();

		Map values = new HashMap();

		values.put("type_code", "1");

		notification.put("title", "hello");

		notification.put("custom_content", values);

		JSONObject json = new JSONObject();

		System.out.println(JsonUtils.formatJsonText(notification));
	}
}
