package com.rapid.j2ee.framework.push.broadcast;

import java.util.ArrayList;
import java.util.List;

import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ApplicationContextEvent;

import com.rapid.j2ee.framework.push.Notification;

public class NotificationEvent extends ApplicationContextEvent {

	private List<Notification> notifications;

	public NotificationEvent(ApplicationContext context,
			Notification notification) {
		super(context);
		this.notifications = new ArrayList<Notification>(1);
		this.notifications.add(notification);
	}

	public NotificationEvent(ApplicationContext context,
			List<Notification> notifications) {
		super(context);
		this.notifications = notifications;
	}

	public NotificationEvent(ApplicationContext context) {
		this(context, new ArrayList<Notification>(5));
	}

	public NotificationEvent addNotification(Notification notification) {
		notifications.add(notification);
		return this;
	}

	public List<Notification> getNotifications() {
		return notifications;
	}

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

}
