package com.rapid.j2ee.framework.push.ios;

import java.util.Set;

import javapns.back.PushNotificationManager;
import javapns.back.SSLConnectionHelper;
import javapns.data.Device;
import javapns.data.PayLoad;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.utils.ResourceUtils;
import com.rapid.j2ee.framework.push.Notification;
import com.rapid.j2ee.framework.push.NotificationPushEvent;

@NotificationPushEvent(IosNotification.class)
public class IosAppPushNotificationProvider extends
		IosNotificationServerConfigurer<PushNotificationManager> {

	private static final Log Logger = LogFactory
			.getLog(IosNotificationServerConfigurer.class);

	@Override
	protected void close(PushNotificationManager pushNotificationManager) {

		try {
			pushNotificationManager.stopConnection();
		} catch (Exception e) {

		}
	}

	@Override
	protected void doPush(PushNotificationManager pushNotificationManager,
			Notification notification) throws Throwable {

		Device device = this.getDevice(pushNotificationManager, notification
				.getNotificationId(), notification.getTokenId());

		PayLoad payLoad = this.getPayLoad((IosNotification) notification);

		pushNotificationManager.sendNotification(device, payLoad);

		Logger.info("doPush " + notification);

	}

	private PayLoad getPayLoad(IosNotification iosNotification)
			throws Exception {

		PayLoad payLoad = new PayLoad();

		payLoad.addAlert(iosNotification.getMessage());
		payLoad.addBadge(iosNotification.getBadge());
		payLoad.addSound(iosNotification.getSound());

		for (String key : (Set<String>) iosNotification.getPropertyKeys()) {
			payLoad.addCustomDictionary(key, iosNotification
					.getDictionaryValue(key));
		}

		return payLoad;
	}

	private Device getDevice(PushNotificationManager manager, String deviceId,
			String tokenId) throws Exception {

		manager.addDevice(deviceId, tokenId);

		return manager.getDevice(deviceId);

	}

	@Override
	protected PushNotificationManager init() {

		try {
			PushNotificationManager pushManager = PushNotificationManager
					.getInstance();

			pushManager.initializeConnection(this.getGateway(), this.getPort(),
					ResourceUtils.getResource(this.getCertificatePath())
							.getInputStream(), this.getCertificatePassword(),
					SSLConnectionHelper.KEYSTORE_TYPE_PKCS12);

			return pushManager;

		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	public static void main(String[] args) {

		IosAppPushNotificationProvider iosAppPushNotification = new IosAppPushNotificationProvider();
		iosAppPushNotification
				.setCertificatePath("classpath:push-developer.p12");
		iosAppPushNotification.setCertificatePassword("123456");
		iosAppPushNotification.setCharset("utf-8");
		iosAppPushNotification.setGateway("gateway.sandbox.push.apple.com");
		iosAppPushNotification.setPort(2195);

		iosAppPushNotification.setPushInterval(1000);

		iosAppPushNotification.setPushInterval(100);

		IosNotification notification = new IosNotification(
				"06f0fb2b634b1da47a85728effa84feb6070e3de7032c245cf169bf9d6881814");
		notification.setMessage("hello world");
		iosAppPushNotification.push(notification);

	}

}
