package com.rapid.j2ee.framework.quartz;

import java.util.Collection;

import javax.sql.DataSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

import com.rapid.j2ee.framework.core.spring.SpringApplicationContextHolder;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.quartz.missfire.QuartzMissJobFire;
import com.rapid.j2ee.framework.quartz.missfire.QuartzMissJobFire.QuartzMissJobFireType;

@SuppressWarnings("unchecked")
public class SchedulerAutowireFactoryBean extends SchedulerFactoryBean {

	@Override
	public void afterPropertiesSet() throws Exception {

		SpringApplicationContextHolder.autowireObjectFieldValue(this,
				"triggers", Trigger.class);

		SpringApplicationContextHolder.autowireObjectFieldValue(this,
				"jobDetails", JobDetail.class);

		SpringApplicationContextHolder.autowireObjectFieldValue(this,
				"globalTriggerListeners", TriggerListener.class);

		super.afterPropertiesSet();

		this.doQuartzMissJobFires(QuartzMissJobFireType.fire);

	}

	protected void registerListeners() throws SchedulerException {

		super.registerListeners();

		try {
			this.doQuartzMissJobFires(QuartzMissJobFireType.check);
		} catch (Exception e) {
			logger.error("registerListeners error!", e);
		}

	}

	public void setDataSource(DataSource dataSource) {
		super.setDataSource(dataSource);
		this.dataSource = dataSource;
	}

	private void doQuartzMissJobFires(QuartzMissJobFireType type)
			throws Exception {

		Collection<QuartzMissJobFire> quartzMissJobFires = applicationContext
				.getBeansOfType(QuartzMissJobFire.class).values();

		if (TypeChecker.isEmpty(quartzMissJobFires)) {
			return;
		}

		for (QuartzMissJobFire fire : quartzMissJobFires) {

			if (QuartzMissJobFire.JOBFIRE_FOR_ALL.equalsIgnoreCase(fire
					.getScheduleName())
					|| fire.getScheduleName().equalsIgnoreCase(
							this.getScheduler().getSchedulerName())) {

				if (QuartzMissJobFireType.check == type) {
					fire.findMissJob(this.applicationContext, this
							.getScheduler(), this.dataSource);
					continue;
				}

				fire.fire(this.applicationContext, this.getScheduler(),
						this.dataSource);

			}

		}
	}

	@Override
	public void setApplicationContext(ApplicationContext applicationContext) {
		this.applicationContext = applicationContext;
		super.setApplicationContext(applicationContext);
	}

	private ApplicationContext applicationContext;

	private DataSource dataSource;

	private static final Log logger = LogFactory
			.getLog(SchedulerAutowireFactoryBean.class);

}
