package com.rapid.j2ee.framework.quartz.interceptor;

import java.util.Date;

import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.springframework.context.ApplicationContext;

import com.rapid.j2ee.framework.quartz.AbstractQuartzJob;
import com.rapid.j2ee.framework.quartz.log.QuartzJobLogger;

public interface QuartzJobInterceptor {

	public enum JobStatus {
		Fail, Success, Interrupt
	};

	public JobStatus beforeJobExecute(QuartzJobLogger quartzJobLogger,
			JobExecutionContext context, ApplicationContext applicationContext,
			Date scheduledFireTime, JobDetail jobDetail) throws Exception;

	public void completeJobExecute(QuartzJobLogger quartzJobLogger,
			JobExecutionContext context, long startTime,
			ApplicationContext applicationContext, Date scheduledFireTime,
			JobDetail jobDetail, Throwable exp, JobStatus status)
			throws Exception;

	public void initQuartzJobBean(ApplicationContext context,
			AbstractQuartzJob abstractQuartzJob);

	public void finalizeJobExecute();

	public String getJobKey();

	public static final String JOBKEY_FOR_ALL = "DEFAULT";
}
