package com.rapid.j2ee.framework.quartz.interceptor;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.collections.MultiHashMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import com.rapid.j2ee.framework.core.utils.CollectionsUtil;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.quartz.AbstractQuartzJob;
import com.rapid.j2ee.framework.quartz.interceptor.QuartzJobInterceptor.JobStatus;
import com.rapid.j2ee.framework.quartz.log.QuartzJobLogger;

public class QuartzJobInterceptorContainer implements InitializingBean,
		ApplicationContextAware {

	public void initQuartzJobBean(AbstractQuartzJob abstractQuartzJob) {

		for (QuartzJobInterceptor interceptor : quartzJobInterceptorsAsDefault) {

			interceptor.initQuartzJobBean(context, abstractQuartzJob);

		}
	}

	public void finalizeJobExecute() {

		for (QuartzJobInterceptor interceptor : quartzJobInterceptorsAsDefault) {

			interceptor.finalizeJobExecute();

		}
	}

	public JobStatus beforeJobExecute(QuartzJobLogger quartzJobLogger,
			JobExecutionContext context, ApplicationContext applicationContext,
			Date scheduledFireTime, JobDetail jobDetail) throws Exception {

		List<QuartzJobInterceptor> interceptors = this
				.getQuartzJobInterceptorsAtJob(jobDetail);

		JobStatus jobStatus = JobStatus.Success;

		for (QuartzJobInterceptor interceptor : interceptors) {

			JobStatus jobStatusResult = interceptor.beforeJobExecute(
					quartzJobLogger, context, applicationContext,
					scheduledFireTime, jobDetail);

			if (jobStatusResult == JobStatus.Fail) {

				return JobStatus.Fail;
			}

			if (jobStatusResult == JobStatus.Interrupt) {
				jobStatus = JobStatus.Interrupt;
			}

		}

		return jobStatus;
	}

	public void completeJobExecute(QuartzJobLogger quartzJobLogger,
			JobExecutionContext context, long startTime,
			ApplicationContext applicationContext, Date scheduledFireTime,
			JobDetail jobDetail, Throwable exp, JobStatus status) {

		try {
			List<QuartzJobInterceptor> interceptors = this
					.getQuartzJobInterceptorsAtJob(jobDetail);
			for (QuartzJobInterceptor interceptor : interceptors) {

				interceptor.completeJobExecute(quartzJobLogger, context,
						startTime, applicationContext, scheduledFireTime,
						jobDetail, exp, status);

			}
		} catch (Throwable e) {
			e.printStackTrace();
		}
	}

	private List<QuartzJobInterceptor> getQuartzJobInterceptorsAtJob(
			JobDetail detail) {

		String jobKey = detail.getKey().getGroup() + "."
				+ detail.getKey().getName();

		if (quartzJobInterceptorMapper.containsKey(jobKey)) {

			List<QuartzJobInterceptor> availableInterceptors = new ArrayList<QuartzJobInterceptor>(
					quartzJobInterceptorsAsDefault);

			availableInterceptors.addAll(quartzJobInterceptorMapper
					.getCollection(jobKey));

			return availableInterceptors;
		}

		return quartzJobInterceptorsAsDefault;

	}

	public void afterPropertiesSet() throws Exception {

		System.out.println("quartzJobInterceptors ======== "
				+ quartzJobInterceptors);

		quartzJobInterceptorMapper = CollectionsUtil
				.convertCollectionToMultipleMapByFieldNames(
						quartzJobInterceptors, "jobKey");

		System.out.println("quartzJobInterceptorMapper ======== "
				+ quartzJobInterceptorMapper);

		if (this.quartzJobInterceptorMapper
				.containsKey(QuartzJobInterceptor.JOBKEY_FOR_ALL)) {

			quartzJobInterceptorsAsDefault = new ArrayList<QuartzJobInterceptor>(
					quartzJobInterceptorMapper
							.getCollection(QuartzJobInterceptor.JOBKEY_FOR_ALL));
		}

	}

	public void setApplicationContext(ApplicationContext context)
			throws BeansException {
		this.context = context;

	}

	private MultiHashMap quartzJobInterceptorMapper = ObjectUtils.EMPTY_MULTIHASHMAP;

	private List<QuartzJobInterceptor> quartzJobInterceptorsAsDefault = ObjectUtils.EMPTY_LIST;

	@Autowired(required = false)
	private List<QuartzJobInterceptor> quartzJobInterceptors = new ArrayList<QuartzJobInterceptor>();

	private ApplicationContext context;

}
