package com.rapid.j2ee.framework.quartz.interceptor;

import java.util.Date;

import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.springframework.context.ApplicationContext;

import com.rapid.j2ee.framework.mvc.security.utils.MvcSecurityActionContextUtils;
import com.rapid.j2ee.framework.quartz.listener.QuartzJobLogApplicationContextEvent;
import com.rapid.j2ee.framework.quartz.log.QuartzJobLogger;

public class QuartzJobLoggerInterceptor extends QuartzJobInterceptorAdatper {

	public String getJobKey() {

		return QuartzJobInterceptor.JOBKEY_FOR_ALL;
	}

	public void completeJobExecute(QuartzJobLogger quartzJobLogger,
			JobExecutionContext context, long startTime,
			ApplicationContext applicationContext, Date scheduledFireTime,
			JobDetail jobDetail, Throwable exp, JobStatus status)
			throws Exception {

		applicationContext
				.publishEvent(new QuartzJobLogApplicationContextEvent(
						applicationContext, quartzJobLogger,
						MvcSecurityActionContextUtils.getWebUser()));

	}

}
