package com.rapid.j2ee.framework.quartz.listener;

import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ApplicationContextEvent;

import com.rapid.j2ee.framework.mvc.security.domain.WebUser;
import com.rapid.j2ee.framework.quartz.log.QuartzJobLogger;

public class QuartzJobLogApplicationContextEvent extends
		ApplicationContextEvent {

	private static final long serialVersionUID = 1L;

	private QuartzJobLogger quartzJobLogger;

	private WebUser webUser;

	public QuartzJobLogApplicationContextEvent(ApplicationContext context,
			QuartzJobLogger quartzJobLogger, WebUser webUser) {

		super(context);

		this.quartzJobLogger = quartzJobLogger;

		this.webUser = webUser;
	}

	public QuartzJobLogger getQuartzJobLogger() {
		return quartzJobLogger;
	}

	public WebUser getWebUser() {
		return webUser;
	}

}
