package com.rapid.j2ee.framework.quartz.listener;

import com.rapid.j2ee.framework.core.spring.AsynchronousApplicationListener;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.security.utils.MvcSecurityActionContextUtils;
import com.rapid.j2ee.framework.orm.medium.MediumSessionMapperOperations;

public class QuartzLogKeepAsynApplicationListener extends
		AsynchronousApplicationListener<QuartzJobLogApplicationContextEvent> {

	@Override
	protected void doHandleApplicationEvent(
			QuartzJobLogApplicationContextEvent event) {

		MvcSecurityActionContextUtils.setBatchJobWebUser(event.getWebUser());

		meduimSessionMapper.insert(event.getQuartzJobLogger());

		if (!TypeChecker.isEmpty(event.getQuartzJobLogger()
				.getQuartzJobLoggerParameters().getQuartzJobLoggerParameters())) {
			meduimSessionMapper.insertList(event.getQuartzJobLogger()
					.getQuartzJobLoggerParameters()
					.getQuartzJobLoggerParameters());
		}

	}

	public void setMeduimSessionMapper(
			MediumSessionMapperOperations meduimSessionMapper) {
		this.meduimSessionMapper = meduimSessionMapper;
	}

	private MediumSessionMapperOperations meduimSessionMapper;

}
