package com.rapid.j2ee.framework.quartz.log;

import java.io.Serializable;
import java.util.Date;

import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.utils.DateTimeUtils;
import com.rapid.j2ee.framework.core.utils.IPAddressUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.orm.medium.annotation.Column;
import com.rapid.j2ee.framework.orm.medium.annotation.ID;
import com.rapid.j2ee.framework.orm.medium.annotation.Table;
import com.rapid.j2ee.framework.quartz.interceptor.QuartzJobInterceptor.JobStatus;

@Table("QRTZ_JOB_LOGGER")
public class QuartzJobLogger implements Serializable {

	@ID
	@Column
	private String loggerId;

	@Column
	private Date executeJobDate;

	@Column
	private String schedName;

	@Column
	private String triggerName;

	@Column
	private String triggerGroup;

	@Column
	private String jobName;

	@Column
	private String jobGroup;

	@Column
	private String jobDescription;

	@Column
	private Date nextFireDate;

	@Column
	private Date prevFireDate;

	@Column
	private String jobPriority;

	@Column
	private String triggerState;

	@Column
	private String triggerType;

	@Column
	private Date startDate;

	@Column
	private Date endDate;

	@Column
	private String calendarName;

	@Column
	private String misfireInstr;

	@Column
	private String jobStatus;

	@Column
	private int jobCostTime;

	@Column
	private String errorReason;

	@Column
	private String executeServerIP;

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private QuartzJobLoggerParameters quartzJobLoggerParameters;

	public QuartzJobLogger(String executionLoggerId, JobExecutionContext context) {

		this.loggerId = executionLoggerId;

		Date startDate = DateTimeUtils.getCurrentDate();

		JobDetail jobDetail = context.getJobDetail();

		if (!TypeChecker.isNull(context.getCalendar())) {
			this.setCalendarName(context.getCalendar().getDescription());
		}

		this.setExecuteJobDate(startDate);

		this.setJobDescription(jobDetail.getDescription());
		this.setJobGroup(jobDetail.getKey().getGroup());
		this.setJobName(jobDetail.getKey().getName());
		this.setJobPriority(String.valueOf(context.getTrigger().getPriority()));

		this.setMisfireInstr(String.valueOf(context.getTrigger()
				.getMisfireInstruction()));
		this.setNextFireDate(context.getNextFireTime());
		this.setPrevFireDate(context.getPreviousFireTime());

		try {
			this.setSchedName(context.getScheduler().getSchedulerName());
		} catch (Exception e) {
			this.setSchedName("Unknown");
		}

		this.setStartDate(startDate);

		this.setTriggerGroup(context.getTrigger().getKey().getGroup());
		this.setTriggerName(context.getTrigger().getKey().getName());

		if (context.getTrigger() instanceof CronTrigger) {
			CronTrigger cronTrigger = (CronTrigger) context.getTrigger();

			this.setTriggerName(this.getTriggerName() + " ( "
					+ cronTrigger.getExpressionSummary() + " ) ");
		}

		this.setTriggerType(context.getTrigger().getClass().getSimpleName());

		this.setExecuteServerIP(IPAddressUtils.getLocalHost().getHostName()
				+ "[" + IPAddressUtils.getLocalHostIP() + "]");
		// String jobLoggerId, String scheduleName
		quartzJobLoggerParameters = new QuartzJobLoggerParameters(this);
	}

	public void endQuartzJobLogger(JobExecutionContext context, Throwable exp,
			JobStatus status) {

		this.setJobCostTime((int) ((System.currentTimeMillis() - this
				.getStartDate().getTime()) / 1000));

		this.setJobStatus(status.toString());

		this.setEndDate(DateTimeUtils.getCurrentDate());

		if (exp != null) {

			String error = ExceptionUtils.printThrowableStack(exp);

			if (error.length() > 2000) {
				error = error.substring(0, 2000);
			}

			this.setErrorReason(error);
		}

	}

	public String getCalendarName() {
		return calendarName;
	}

	public void setCalendarName(String calendarName) {
		this.calendarName = calendarName;
	}

	public String getErrorReason() {
		return errorReason;
	}

	public void setErrorReason(String errorReason) {
		this.errorReason = errorReason;
	}

	public Date getExecuteJobDate() {
		return executeJobDate;
	}

	public void setExecuteJobDate(Date executeJobDate) {
		this.executeJobDate = executeJobDate;
	}

	public int getJobCostTime() {
		return jobCostTime;
	}

	public void setJobCostTime(int jobCostTime) {
		this.jobCostTime = jobCostTime;
	}

	public String getJobDescription() {
		return jobDescription;
	}

	public void setJobDescription(String jobDescription) {
		this.jobDescription = jobDescription;
	}

	public String getJobGroup() {
		return jobGroup;
	}

	public void setJobGroup(String jobGroup) {
		this.jobGroup = jobGroup;
	}

	public String getJobName() {
		return jobName;
	}

	public void setJobName(String jobName) {
		this.jobName = jobName;
	}

	public String getJobPriority() {
		return jobPriority;
	}

	public void setJobPriority(String jobPriority) {
		this.jobPriority = jobPriority;
	}

	public String getJobStatus() {
		return jobStatus;
	}

	public void setJobStatus(String jobStatus) {
		this.jobStatus = jobStatus;
	}

	public String getLoggerId() {
		return loggerId;
	}

	public void setLoggerId(String loggerId) {
		this.loggerId = loggerId;
	}

	public String getMisfireInstr() {
		return misfireInstr;
	}

	public void setMisfireInstr(String misfireInstr) {
		this.misfireInstr = misfireInstr;
	}

	public Date getNextFireDate() {
		return nextFireDate;
	}

	public void setNextFireDate(Date nextFireDate) {
		this.nextFireDate = nextFireDate;
	}

	public Date getPrevFireDate() {
		return prevFireDate;
	}

	public void setPrevFireDate(Date prevFireDate) {
		this.prevFireDate = prevFireDate;
	}

	public String getSchedName() {
		return schedName;
	}

	public void setSchedName(String schedName) {
		this.schedName = schedName;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public String getTriggerGroup() {
		return triggerGroup;
	}

	public void setTriggerGroup(String triggerGroup) {
		this.triggerGroup = triggerGroup;
	}

	public String getTriggerName() {
		return triggerName;
	}

	public void setTriggerName(String triggerName) {
		this.triggerName = triggerName;
	}

	public String getTriggerState() {
		return triggerState;
	}

	public void setTriggerState(String triggerState) {
		this.triggerState = triggerState;
	}

	public String getTriggerType() {
		return triggerType;
	}

	public void setTriggerType(String triggerType) {
		this.triggerType = triggerType;
	}

	public String getExecuteServerIP() {
		return executeServerIP;
	}

	public void setExecuteServerIP(String executeServerIP) {
		this.executeServerIP = executeServerIP;
	}

	public QuartzJobLoggerParameters getQuartzJobLoggerParameters() {
		return quartzJobLoggerParameters;
	}

}
