package com.rapid.j2ee.framework.quartz.log;

import java.util.ArrayList;
import java.util.List;

import com.rapid.j2ee.framework.core.utils.ObjectUtils;

public class QuartzJobLoggerParameters {

	private List<QuartzJobLoggerParameter> quartzJobLoggerParameters = ObjectUtils.EMPTY_LIST;

	private String jobLoggerId;

	private String scheduleName;

	public QuartzJobLoggerParameters(QuartzJobLogger quartzJobLogger) {
		this.jobLoggerId = quartzJobLogger.getLoggerId();
		this.scheduleName = quartzJobLogger.getSchedName();
	}

	public boolean isEmpty() {
		return quartzJobLoggerParameters.isEmpty();
	}

	public void addQuartzJobLoggerParameter(QuartzJobLoggerParameter param) {

		if (quartzJobLoggerParameters == ObjectUtils.EMPTY_LIST) {
			quartzJobLoggerParameters = new ArrayList<QuartzJobLoggerParameter>(
					5);
		}

		param.setParameterSeqNo(quartzJobLoggerParameters.size());
		param.setLoggerId(this.jobLoggerId);
		param.setSchedName(scheduleName);

		quartzJobLoggerParameters.add(param);

	}

	public void addQuartzJobLoggerInParameter(String paramName,
			String paramValue) {

		QuartzJobLoggerParameter parameter = QuartzJobLoggerParameter
				.getInParameter();
		parameter.setParameterName(paramName);
		parameter.setParameterValue(paramValue);

		addQuartzJobLoggerParameter(parameter);
	}

	public void addQuartzJobLoggerOutParameter(String paramName,
			String paramValue) {

		QuartzJobLoggerParameter parameter = QuartzJobLoggerParameter
				.getOutParameter();

		parameter.setParameterName(paramName);
		parameter.setParameterValue(paramValue);

		addQuartzJobLoggerParameter(parameter);
	}

	public void addQuartzJobLoggerInParameter(QuartzJobLoggerParameter param) {
		param.setParameterType("IN");
		addQuartzJobLoggerParameter(param);
	}

	public void addQuartzJobLoggerOutParameter(QuartzJobLoggerParameter param) {
		param.setParameterType("OUT");
		addQuartzJobLoggerParameter(param);

	}

	public List<QuartzJobLoggerParameter> getQuartzJobLoggerParameters() {

		return quartzJobLoggerParameters;
	}

}
