package com.rapid.j2ee.framework.quartz.missfire;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.sql.DataSource;

import org.quartz.JobDataMap;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;

import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class QuartzDefaultMissJobFire implements QuartzMissJobFire {

	private ThreadLocal<List<Map<String, Object>>> cronTriggerJob_ThreadLocale = new ThreadLocal<List<Map<String, Object>>>();

	public void findMissJob(ApplicationContext context, Scheduler schedule,
			DataSource dataSource) throws Exception {

		JdbcTemplate template = getJdbcTemplate(context, dataSource);

		List<Map<String, Object>> cronTriggerJobs = template
				.queryForList("SELECT TRIGGER_NAME,TRIGGER_GROUP,JOB_NAME,JOB_GROUP,DESCRIPTION,NEXT_FIRE_TIME FROM "
						+ qutzTriggersTableName
						+ " WHERE NEXT_FIRE_TIME<"
						+ System.currentTimeMillis()
						+ " AND TRIGGER_TYPE='CRON' AND SCHED_NAME='"
						+ schedule.getSchedulerName() + "'");

		cronTriggerJob_ThreadLocale.set(cronTriggerJobs);

	}

	public void fire(ApplicationContext context, Scheduler schedule,
			DataSource dataSource) throws Exception {

		List<Map<String, Object>> cronTriggerJobs = cronTriggerJob_ThreadLocale
				.get();

		if (TypeChecker.isEmpty(cronTriggerJobs)) {
			return;
		}

		for (Map<String, Object> jobTrigger : cronTriggerJobs) {

			// NEXT_FIRE_TIME

			JobDataMap jobDataMap = new JobDataMap();

			jobDataMap.put("re-run-firedate", String.valueOf(jobTrigger
					.get("NEXT_FIRE_TIME")));

			schedule.triggerJob(JobKey.jobKey((String) jobTrigger
					.get("JOB_NAME"), (String) jobTrigger.get("JOB_GROUP")),
					jobDataMap);

		}
	}

	private JdbcTemplate getJdbcTemplate(ApplicationContext context,
			DataSource dataSource) {

		if (TypeChecker.isNull(jdbcTemplate)) {

			jdbcTemplate = new JdbcTemplate();
			jdbcTemplate.setDataSource(dataSource);

			autowireNativeJdbcExtractor(context, jdbcTemplate);
		}

		return jdbcTemplate;

	}

	private void autowireNativeJdbcExtractor(ApplicationContext context,
			JdbcTemplate template) {

		if (!TypeChecker.isNull(nativeJdbcExtractor)) {
			template.setNativeJdbcExtractor(nativeJdbcExtractor);
			return;
		}

		Collection<NativeJdbcExtractor> extractors = context.getBeansOfType(
				NativeJdbcExtractor.class).values();

		Set<Class> extractorImpClass = new HashSet<Class>();

		for (NativeJdbcExtractor nativeJdbcExtractor : extractors) {
			extractorImpClass.add(nativeJdbcExtractor.getClass());
		}

		if (extractorImpClass.size() == 1) {
			Iterator<NativeJdbcExtractor> it = extractors.iterator();
			it.hasNext();
			template.setNativeJdbcExtractor(it.next());
		}

	}

	public void setNativeJdbcExtractor(NativeJdbcExtractor nativeJdbcExtractor) {
		this.nativeJdbcExtractor = nativeJdbcExtractor;
	}

	public String getScheduleName() {

		return QuartzMissJobFire.JOBFIRE_FOR_ALL;
	}

	private NativeJdbcExtractor nativeJdbcExtractor;

	private JdbcTemplate jdbcTemplate;

	private String qutzTriggersTableName = "QRTZ_TRIGGERS";

}
