package com.rapid.j2ee.framework.smartdbimport;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.core.utils.DateTimeUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.smartdbimport.annotation.SmartImportResourceExecuteBatchLogger;
import com.rapid.j2ee.framework.smartdbimport.configurer.AbstractImportTableConfigurable;
import com.rapid.j2ee.framework.smartdbimport.error.SmartTableColumnDataValidationErrorReceiver;
import com.rapid.j2ee.framework.smartdbimport.execute.SmartResourceImportDatabaseMediumExecutor;
import com.rapid.j2ee.framework.smartdbimport.execute.logger.SmartImportExecuteLoggable;
import com.rapid.j2ee.framework.smartdbimport.resource.ResourceLineReader;
import com.rapid.j2ee.framework.smartdbimport.support.SmartResourceImportFormatGeneralValidator;
import com.rapid.j2ee.framework.smartdbimport.support.SmartResourceImportFormatValidator;
import com.rapid.j2ee.framework.smartdbimport.support.SmartResourceImportJavaBeanVerifiable;
import com.rapid.j2ee.framework.smartdbimport.support.SmartResourceImportJavaBeanVerification;
import com.rapid.j2ee.framework.smartdbimport.support.SmartResourceImportResult;
import com.rapid.j2ee.framework.smartdbimport.support.SmartResourceOrmJavaBeanBuilder;

public class SmartResourceImportDatabaseExecutor implements
		SmartResourceImportDatabase, SmartResourceImportDatabaseAware {

	private SmartResourceImportResult smartResourceImportResult;

	private ResourceLineReader resourceLineReader;

	private AbstractImportTableConfigurable importTableConfigurable;

	private SmartResourceImportFormatValidator smartResourceImportFormatValidator;

	private SmartResourceOrmJavaBeanBuilder smartResourceJavaBeanAssembleBuilder;

	private SmartResourceImportJavaBeanVerifiable smartResourceImportJavaBeanVerifiable;

	private int totalImportedDataCount = 0;

	private int totalImportedAccurateDataCount = 0;

	private SmartResourceImportDatabaseMediumExecutor executor = null;

	private SmartImportExecuteLoggable smartImportExecuteLoggable;

	public SmartResourceImportDatabaseExecutor(
			ResourceLineReader resourceLineReader,
			AbstractImportTableConfigurable importTableConfigurable) {

		this.smartResourceImportFormatValidator = new SmartResourceImportFormatGeneralValidator(
				this);

		smartResourceImportResult = new SmartResourceImportResult();

		this.resourceLineReader = resourceLineReader;

		this.importTableConfigurable = importTableConfigurable;

		this.smartResourceJavaBeanAssembleBuilder = new SmartResourceOrmJavaBeanBuilder(
				importTableConfigurable,
				this.smartResourceImportFormatValidator);

		this.smartResourceImportJavaBeanVerifiable = new SmartResourceImportJavaBeanVerification(
				this.importTableConfigurable,
				smartResourceImportFormatValidator);

	}

	public boolean validateResourceFormat() {

		resourceLineReader.parseResource();

		return this.smartResourceImportFormatValidator.validate();

	}

	public SmartImportExecuteLoggable execute() {

		Assert
				.notNull(executor,
						"Please provide a sql executor [SmartResourceImportDatabaseORMapExecutor]");

		this.prepareSmartImportExecuteLoggable();

		while (resourceLineReader.hasNextColumnData()) {

			this.totalImportedDataCount++;

			Serializable ormapJavaBean = (Serializable) smartResourceJavaBeanAssembleBuilder
					.buildByTableRealColumnConfigurers(resourceLineReader);

			smartResourceJavaBeanAssembleBuilder.appendResourceExecuteBatchId(
					ormapJavaBean, smartImportExecuteLoggable);

			boolean javaBeanResult = smartResourceImportJavaBeanVerifiable
					.verify(ormapJavaBean);

			ormapJavaBean = smartResourceImportJavaBeanVerifiable
					.getConvertedJavaBean();

			if (javaBeanResult) {
				totalImportedAccurateDataCount++;
			}

			smartResourceJavaBeanAssembleBuilder
					.appendTableVirtualColumnInformations(ormapJavaBean,
							resourceLineReader);

			executor
					.execute(
							this.smartImportExecuteLoggable,
							(SmartTableColumnDataValidationErrorReceiver) ormapJavaBean);

		}

		executor.end(this.smartImportExecuteLoggable);

		this.endSmartImportExecuteLoggable();

		return this.smartImportExecuteLoggable;

	}

	private void prepareSmartImportExecuteLoggable() {

		getSmartImportExecuteLoggable().prepare(importTableConfigurable);
		getSmartImportExecuteLoggable().prepare(
				smartResourceImportFormatValidator);

		executor.insert(getSmartImportExecuteLoggable());

	}

	private SmartImportExecuteLoggable getSmartImportExecuteLoggable() {

		System.out.println("smartImportExecuteLoggable ============= "
				+ ToStringBuilder
						.reflectionToString(this.smartImportExecuteLoggable));

		if (!TypeChecker.isNull(this.smartImportExecuteLoggable)) {
			return this.smartImportExecuteLoggable;
		}

		try {

			Class ormJavaBean = Class.forName(this.importTableConfigurable
					.getOrmapJavaClassName());

			this.smartImportExecuteLoggable = (SmartImportExecuteLoggable) ConstructorUtils
					.newInstance(((SmartImportResourceExecuteBatchLogger) ormJavaBean
							.getAnnotation(SmartImportResourceExecuteBatchLogger.class))
							.value());

			return this.smartImportExecuteLoggable;

		} catch (ClassNotFoundException e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	private void endSmartImportExecuteLoggable() {

		smartImportExecuteLoggable
				.setTotalImportCount(this.totalImportedDataCount);
		smartImportExecuteLoggable
				.setTotalImportAccurateCount(this.totalImportedAccurateDataCount);
		smartImportExecuteLoggable
				.setTotalFirstImportErrorCount(this.totalImportedDataCount
						- this.totalImportedAccurateDataCount);
		smartImportExecuteLoggable.setFileImportEndDate(DateTimeUtils
				.getCurrentDate());

		executor.update(smartImportExecuteLoggable);
	}

	public SmartResourceImportResult getSmartResourceImportResult() {
		return smartResourceImportResult;
	}

	public ResourceLineReader getResourceLineReader() {

		return this.resourceLineReader;
	}

	public AbstractImportTableConfigurable getImportTableConfigurable() {

		return this.importTableConfigurable;
	}

	public static void main(String[] args) {

		// ImportDemoTableConfigurable importDemoTableConfigurable = new
		// ImportDemoTableConfigurable();
		//
		// ImportExcelResourceLineParserReader
		// importExcelResourceLineParserReader = new
		// ImportExcelResourceLineParserReader(
		// new FileSystemResource("c:\\test.xls"),
		// importDemoTableConfigurable);
		//
		// SmartResourceImportDatabaseExecutor
		// smartResourceImportJavaBeanAssembleFactory = new
		// SmartResourceImportDatabaseExecutor(
		// importExcelResourceLineParserReader,
		// importDemoTableConfigurable);
		//
		// SmartResourceImportDatabaseORMapBatchExecutor executor = new
		// SmartResourceImportDatabaseORMapBatchExecutor();
		//
		// smartResourceImportJavaBeanAssembleFactory
		// .setSmartResourceImportDatabaseORMapExecutor(executor);
		//
		// if (!smartResourceImportJavaBeanAssembleFactory
		// .validateResourceFormat()) {
		// System.out.println(smartResourceImportJavaBeanAssembleFactory
		// .getSmartResourceImportResult()
		// .getImportResourceFormatError());
		//
		// return;
		// }
		//
		// smartResourceImportJavaBeanAssembleFactory.execute();

	}

	public void setSmartResourceImportDatabaseMediumExecutor(
			SmartResourceImportDatabaseMediumExecutor executor) {
		this.executor = executor;
	}

	public void setSmartImportExecuteLoggable(
			SmartImportExecuteLoggable smartImportExecuteLoggable) {

		this.smartImportExecuteLoggable = smartImportExecuteLoggable;

	}

}
