package com.rapid.j2ee.framework.smartdbimport.configurer;

import java.util.ArrayList;
import java.util.List;

import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.orm.medium.bean.BaseMediumBean;

public abstract class AbstractImportTableConfigurable extends BaseMediumBean
		implements ImportTableConfigurable {
	
	@SuppressWarnings("unchecked")
	private List<ImportTableColumnConfigurable> importTableRealColumnConfigurers = ObjectUtils.EMPTY_LIST;

	@SuppressWarnings("unchecked")
	private List<ImportTableVirtualColumnMapperConfigurable> importTableVirtualColumnConfigurers = ObjectUtils.EMPTY_LIST;

	public List<ImportTableColumnConfigurable> getImportTableRealColumnConfigurers() {

		if (this.isEmptyTableColumns()
				|| !TypeChecker.isEmpty(importTableRealColumnConfigurers)) {
			return this.importTableRealColumnConfigurers;
		}

		importTableRealColumnConfigurers = new ArrayList<ImportTableColumnConfigurable>(
				importTableRealColumnConfigurers.size());

		for (ImportTableColumnConfigurable importTableColumnConfigurable : this
				.getImportTableColumnConfigurers()) {

			if (importTableColumnConfigurable instanceof ImportTableVirtualColumnMapperConfigurable) {
				continue;
			}

			importTableRealColumnConfigurers.add(importTableColumnConfigurable);
		}

		return importTableRealColumnConfigurers;
	}

	public List<ImportTableVirtualColumnMapperConfigurable> getImportTableVirtualColumnConfigurers() {

		if (this.isEmptyTableColumns()
				|| !TypeChecker.isEmpty(importTableVirtualColumnConfigurers)) {
			return this.importTableVirtualColumnConfigurers;
		}

		importTableVirtualColumnConfigurers = new ArrayList<ImportTableVirtualColumnMapperConfigurable>(
				((int) (importTableRealColumnConfigurers.size() * 0.25)) + 1);

		for (ImportTableColumnConfigurable importTableColumnConfigurable : this
				.getImportTableColumnConfigurers()) {

			if (importTableColumnConfigurable instanceof ImportTableVirtualColumnMapperConfigurable) {
				importTableVirtualColumnConfigurers
						.add((ImportTableVirtualColumnMapperConfigurable) importTableColumnConfigurable);
			}

		}

		return importTableVirtualColumnConfigurers;
	}

	public boolean isEmptyTableColumns() {
		return TypeChecker.isEmpty(this.getImportTableColumnConfigurers());
	}
}
