package com.rapid.j2ee.framework.smartdbimport.configurer;

import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.utils.Constants;

public enum SmartImportSupportType {

	ColumnNameMapperResource(true), DirectMapperIndexResource(false);

	private static final Constants<SmartImportSupportType> smartImportSupportTypeConstant = new Constants<SmartImportSupportType>(
			SmartImportSupportType.class, true);

	private boolean containsResouceColumnNamesHeader;

	private SmartImportSupportType(boolean containsResouceColumnNamesHeader) {
		this.containsResouceColumnNamesHeader = containsResouceColumnNamesHeader;

	}

	public boolean containsResouceColumnNamesHeader() {
		return containsResouceColumnNamesHeader;
	}

	public static SmartImportSupportType getSmartImportSupportTypes(String name) {

		Assert.notNull(smartImportSupportTypeConstant.asObject(name),
				"Cannot find any Smart Import Support Type By [" + name + "]");

		return smartImportSupportTypeConstant.asObject(name);
	}

	public static void main(String[] args) {
		System.out.println(SmartImportSupportType
				.getSmartImportSupportTypes("ColumnNameMapperResource"));
	}

}
