package com.rapid.j2ee.framework.smartdbimport.converter;

import com.rapid.j2ee.framework.core.utils.TypeChecker;

public abstract class AbstractSmartTableColumnDataTypeConverter implements
		SmartTableColumnDataTypeConverter {

	public String convertEvenError(String columnValue) {
		try {
			if (TypeChecker.isEmpty(columnValue)) {
				return columnValue;
			}

			return this.doConvertEvenError(columnValue,
					SmartTableColumnDataTypeConverterParametersHolder
							.getInstance().getParameters());
		} finally {
			SmartTableColumnDataTypeConverterParametersHolder.getInstance()
					.clear();
		}
	}

	public String convertWhenSucess(String columnValue) {
		try {
			if (TypeChecker.isEmpty(columnValue)) {
				return columnValue;
			}

			return this.doConvertWhenSucess(columnValue,
					SmartTableColumnDataTypeConverterParametersHolder
							.getInstance().getParameters());
		} finally {
			SmartTableColumnDataTypeConverterParametersHolder.getInstance()
					.clear();
		}

	}

	protected abstract String doConvertEvenError(String columnValue,
			Object[] arguments);

	protected abstract String doConvertWhenSucess(String columnValue,
			Object[] arguments);

}
