package com.rapid.j2ee.framework.smartdbimport.converter;

import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.utils.NumberUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;

public class SmartTableColumnDataTypeLengthConverter extends
		AbstractSmartTableColumnDataTypeConverter {

	@Override
	protected String doConvertEvenError(String columnValue, Object[] arguments) {

		Assert.noNullElements(arguments, "The arguments must not be empty!");
		Assert.isTrue(arguments.length == 2, "The arguments must be 2 length!");
		Assert.isTrue(
				NumberUtils.parseInt(String.valueOf(arguments[0])) - 6 > 0,
				"The max length must be larger than 6!");

		return StringUtils.getStringContextWithinLength(columnValue,
				NumberUtils.parseDouble(String.valueOf(arguments[1])),
				NumberUtils.parseInt(String.valueOf(arguments[0])) - 6,
				"......");
	}

	@Override
	protected String doConvertWhenSucess(String columnValue, Object[] arguments) {

		return columnValue;
	}

}
