package com.rapid.j2ee.framework.smartdbimport.execute;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.orm.medium.MediumSessionMapperOperations;
import com.rapid.j2ee.framework.smartdbimport.error.SmartTableColumnDataValidationErrorReceiver;
import com.rapid.j2ee.framework.smartdbimport.execute.logger.SmartImportExecuteLoggable;
import com.rapid.j2ee.framework.smartdbimport.execute.logger.SmartImportResourceFieldErrorLoggable;

public class SmartResourceImportDatabaseMediumBatchExecutor implements
		SmartResourceImportDatabaseMediumExecutor {

	public MediumSessionMapperOperations mediumSessionMapperOperations;

	private List<SmartTableColumnDataValidationErrorReceiver> ormapJavaBeanCarriers;

	private int batchSize;

	public SmartResourceImportDatabaseMediumBatchExecutor() {
		batchSize = 20;
	}

	public void insert(Serializable javaBean) {

		mediumSessionMapperOperations.insert(javaBean);
	}

	public void update(Serializable javaBean) {

		mediumSessionMapperOperations.update(javaBean);

	}

	public void execute(SmartImportExecuteLoggable smartImportExecuteLoggable,
			SmartTableColumnDataValidationErrorReceiver ormapJavaBean) {

		if (TypeChecker.isNull(ormapJavaBeanCarriers)) {
			ormapJavaBeanCarriers = new ArrayList<SmartTableColumnDataValidationErrorReceiver>(
					batchSize);
		}

		if (ormapJavaBeanCarriers.size() <= this.batchSize) {
			ormapJavaBeanCarriers.add(ormapJavaBean);

		}

		if (ormapJavaBeanCarriers.size() >= this.batchSize) {

			executeImportRecords(smartImportExecuteLoggable);
		}
	}

	public void end(SmartImportExecuteLoggable smartImportExecuteLoggable) {

		if (TypeChecker.isEmpty(ormapJavaBeanCarriers)) {
			return;
		}

		executeImportRecords(smartImportExecuteLoggable);

		ormapJavaBeanCarriers = null;
	}

	public void setBatchSize(int batchSize) {
		this.batchSize = batchSize;
	}

	public void setMediumSessionMapperOperations(
			MediumSessionMapperOperations mediumSessionMapperOperations) {
		this.mediumSessionMapperOperations = mediumSessionMapperOperations;
	}

	private void executeImportRecords(
			SmartImportExecuteLoggable smartImportExecuteLoggable) {

		mediumSessionMapperOperations.insertList(ormapJavaBeanCarriers);

		for (SmartTableColumnDataValidationErrorReceiver receiver : ormapJavaBeanCarriers) {

			this.bindExecutedBatchId(smartImportExecuteLoggable, receiver);

			mediumSessionMapperOperations.insertList(receiver
					.getSmartImportResourceFieldErrorLoggers());
		}

		ormapJavaBeanCarriers.clear();

	}

	private void bindExecutedBatchId(
			SmartImportExecuteLoggable smartImportExecuteLoggable,
			SmartTableColumnDataValidationErrorReceiver receiver) {

		if (TypeChecker.isEmpty(receiver
				.getSmartImportResourceFieldErrorLoggers())) {
			return;
		}

		for (SmartImportResourceFieldErrorLoggable smartImportResourceFieldErrorLoggable : receiver
				.getSmartImportResourceFieldErrorLoggers()) {

			smartImportResourceFieldErrorLoggable
					.setFileImportExecBatchId(smartImportExecuteLoggable
							.getFileImportExecBatchId());

		}

	}

}
