package com.rapid.j2ee.framework.smartdbimport.execute.logger;

import java.util.Date;

import com.rapid.j2ee.framework.core.utils.DateTimeUtils;
import com.rapid.j2ee.framework.core.utils.ObjectAnalyzer;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.orm.medium.annotation.Column;
import com.rapid.j2ee.framework.orm.medium.annotation.ID;
import com.rapid.j2ee.framework.orm.medium.bean.BaseMediumBean;
import com.rapid.j2ee.framework.smartdbimport.configurer.ImportTableConfigurable;
import com.rapid.j2ee.framework.smartdbimport.support.SmartResourceImportFormatValidator;

public class SmartImportExecuteLogger extends BaseMediumBean implements
		SmartImportExecuteLoggable {

	@ID
	@Column
	private String fileImportExecBatchId;

	@Column
	private String fileImportConfigId;

	@Column
	private String fileImportConfigName;

	@Column
	private String ormapJavaClassName;

	@Column
	private String fileImportSupportType;

	@Column
	private Date fileImportStartDate;

	@Column
	private Date fileImportEndDate;

	@Column
	private String fileImportOperatorId;

	@Column
	private String fileImportColumnIndexMapper;

	@Column
	private Integer totalImportCount;

	@Column
	private Integer totalImportAccurateCount;

	@Column
	private Integer totalFirstImportErrorCount;

	public void prepare(ImportTableConfigurable importTableConfigurable) {
		this.ormapJavaClassName = importTableConfigurable
				.getOrmapJavaClassName();

		this.fileImportConfigName = importTableConfigurable
				.getFileImportConfigName();

		this.fileImportConfigId = importTableConfigurable
				.getFileImportConfigId();

		this.fileImportStartDate = DateTimeUtils.getCurrentDate();

		this.fileImportOperatorId = getFileImportOperationIdForPrepare();

		this.fileImportSupportType = importTableConfigurable
				.getFileSmartImportSupportType().toString();

	}

	public void prepare(
			SmartResourceImportFormatValidator smartResourceImportFormatValidator) {

		this.fileImportColumnIndexMapper = StringUtils.getMapGroupItemBunch(
				smartResourceImportFormatValidator
						.getJavaFieldIndexOfResourceColumnMapper(), ":", ";");
	}

	protected String getFileImportOperationIdForPrepare() {
		return "Unkown Account";
	}

	public String getFileImportColumnIndexMapper() {
		return fileImportColumnIndexMapper;
	}

	public void setFileImportColumnIndexMapper(
			String fileImportColumnIndexMapper) {
		this.fileImportColumnIndexMapper = fileImportColumnIndexMapper;
	}

	public String getFileImportConfigId() {
		return fileImportConfigId;
	}

	public void setFileImportConfigId(String fileImportConfigId) {
		this.fileImportConfigId = fileImportConfigId;
	}

	public String getFileImportConfigName() {
		return fileImportConfigName;
	}

	public void setFileImportConfigName(String fileImportConfigName) {
		this.fileImportConfigName = fileImportConfigName;
	}

	public Date getFileImportEndDate() {
		return fileImportEndDate;
	}

	public void setFileImportEndDate(Date fileImportEndDate) {
		this.fileImportEndDate = fileImportEndDate;
	}

	public String getFileImportExecBatchId() {
		return fileImportExecBatchId;
	}

	public void setFileImportExecBatchId(String fileImportExecBatchId) {
		this.fileImportExecBatchId = fileImportExecBatchId;
	}

	public String getFileImportOperatorId() {
		return fileImportOperatorId;
	}

	public void setFileImportOperatorId(String fileImportOperatorId) {
		this.fileImportOperatorId = fileImportOperatorId;
	}

	public Date getFileImportStartDate() {
		return fileImportStartDate;
	}

	public void setFileImportStartDate(Date fileImportStartDate) {
		this.fileImportStartDate = fileImportStartDate;
	}

	public String getFileImportSupportType() {
		return fileImportSupportType;
	}

	public void setFileImportSupportType(String fileImportSupportType) {
		this.fileImportSupportType = fileImportSupportType;
	}

	public String getOrmapJavaClassName() {
		return ormapJavaClassName;
	}

	public void setOrmapJavaClassName(String ormapJavaClassName) {
		this.ormapJavaClassName = ormapJavaClassName;
	}

	public Integer getTotalFirstImportErrorCount() {
		return totalFirstImportErrorCount;
	}

	public void setTotalFirstImportErrorCount(Integer totalFirstImportErrorCount) {
		this.totalFirstImportErrorCount = totalFirstImportErrorCount;
	}

	public Integer getTotalImportAccurateCount() {
		return totalImportAccurateCount;
	}

	public void setTotalImportAccurateCount(Integer totalImportAccurateCount) {
		this.totalImportAccurateCount = totalImportAccurateCount;
	}

	public Integer getTotalImportCount() {
		return totalImportCount;
	}

	public void setTotalImportCount(Integer totalImportCount) {
		this.totalImportCount = totalImportCount;
	}

	public String toString() {
		return ObjectAnalyzer.toString(this);
	}

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

}
