package com.rapid.j2ee.framework.smartdbimport.execute.logger;

import java.text.MessageFormat;
import java.util.Locale;

import com.rapid.j2ee.framework.core.reflect.InvokeUtils;
import com.rapid.j2ee.framework.core.utils.ObjectAnalyzer;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.orm.medium.annotation.Column;
import com.rapid.j2ee.framework.orm.medium.annotation.ID;
import com.rapid.j2ee.framework.orm.medium.annotation.Order;
import com.rapid.j2ee.framework.orm.medium.annotation.ID.IDMode;
import com.rapid.j2ee.framework.smartdbimport.configurer.ImportTableColumnConfigurable;
import com.rapid.j2ee.framework.smartdbimport.support.SmartResourceImportResult.ErrorInformation;

public class SmartImportResourceFieldErrorLogger implements
		SmartImportResourceFieldErrorLoggable {

	@Column
	@ID(value = IDMode.IDQUERY,nullNotSql=true)
	private String fileImportExecBatchId = "";

	@Column
	@ID(value = IDMode.IDQUERY,nullNotSql=true)
	private String smartImportRecId = "";

	@Column
	private String javaFieldName = "";

	@Column
	private String tableColumnName = "";

	@Column
	private String errorFinalMessage = "";

	@Column
	private String errorMessage = "";

	@Column
	private String columnValue = "";

	@Column
	private String errorType = "";

	@Column
	private String errorParam1 = "";

	@Column
	private String errorParam2 = "";

	@Column
	private String errorParam3 = "";

	@Column
	private String errorParam4 = "";

	@Column
	private String errorParam5 = "";

	@Column
	private String errorParam6 = "";

	@Column
	@Order(1)
	private int errorDataRowLine;

	@Column
	@Order(2)
	private int errorDataColumnNum;

	private ErrorInformation errorInformation;

	public SmartImportResourceFieldErrorLogger() {

	}

	public SmartImportResourceFieldErrorLoggable prepare(int rowNumber,
			int columnNumber, String importRecordId, String columnValue,
			ImportTableColumnConfigurable importTableColumnConfigurable,
			ErrorInformation errorInformation) {

		this.errorInformation = errorInformation;

		this.columnValue = columnValue;

		this.smartImportRecId = importRecordId;
		this.javaFieldName = importTableColumnConfigurable.getJavaFieldName();
		this.tableColumnName = importTableColumnConfigurable
				.getTableColumnName();
		this.errorDataRowLine = rowNumber;
		this.errorDataColumnNum = columnNumber;
		this.errorType = errorInformation.getErrorType().toString();
		this.errorMessage = errorInformation.getErrorMessage();

		String[] errorPointParameters = errorInformation
				.getErrorPointParameters();

		if (TypeChecker.isEmpty(errorPointParameters)) {
			return this;
		}

		for (int i = 0; i < errorPointParameters.length; i++) {

			try {

				InvokeUtils.setField(this, "errorParam" + (i + 1), String
						.valueOf(errorPointParameters[i]));

			} catch (Exception e) {

				e.printStackTrace();
			}
		}

		this.errorFinalMessage = formateErrorMessage();

		return this;

	}

	protected String formateErrorMessage() {

		return new MessageFormat("", Locale.CHINA).format(this.errorMessage,
				errorInformation.getErrorPointParameters());
	}

	public String getErrorFinalMessage() {
		return errorFinalMessage;
	}

	public void setErrorFinalMessage(String errorFinalMessage) {
		this.errorFinalMessage = errorFinalMessage;
	}

	public String getErrorMessage() {
		return errorMessage;
	}

	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}

	public String getErrorParam1() {
		return errorParam1;
	}

	public void setErrorParam1(String errorParam1) {
		this.errorParam1 = errorParam1;
	}

	public String getErrorParam2() {
		return errorParam2;
	}

	public void setErrorParam2(String errorParam2) {
		this.errorParam2 = errorParam2;
	}

	public String getErrorParam3() {
		return errorParam3;
	}

	public void setErrorParam3(String errorParam3) {
		this.errorParam3 = errorParam3;
	}

	public String getErrorParam4() {
		return errorParam4;
	}

	public void setErrorParam4(String errorParam4) {
		this.errorParam4 = errorParam4;
	}

	public String getErrorParam5() {
		return errorParam5;
	}

	public void setErrorParam5(String errorParam5) {
		this.errorParam5 = errorParam5;
	}

	public String getErrorType() {
		return errorType;
	}

	public void setErrorType(String errorType) {
		this.errorType = errorType;
	}

	public String getJavaFieldName() {
		return javaFieldName;
	}

	public void setJavaFieldName(String javaFieldName) {
		this.javaFieldName = javaFieldName;
	}

	public String getSmartImportRecId() {
		return smartImportRecId;
	}

	public void setSmartImportRecId(String smartImportRecId) {
		this.smartImportRecId = smartImportRecId;
	}

	public String toString() {
		return ObjectAnalyzer.toString(this);
	}

	public String getErrorParam6() {
		return errorParam6;
	}

	public void setErrorParam6(String errorParam6) {
		this.errorParam6 = errorParam6;
	}

	public int getErrorDataColumnNum() {
		return errorDataColumnNum;
	}

	public int getErrorDataRowLine() {
		return errorDataRowLine;
	}

	public ErrorInformation getErrorInformation() {
		return errorInformation;
	}

	public void setErrorInformation(ErrorInformation errorInformation) {
		this.errorInformation = errorInformation;
	}

	public void setErrorDataRowLine(int errorDataRowLine) {
		this.errorDataRowLine = errorDataRowLine;
	}

	public void setErrorDataColumnNum(int errorDataColumnNum) {
		this.errorDataColumnNum = errorDataColumnNum;
	}

	public String getTableColumnName() {
		return tableColumnName;
	}

	public void setTableColumnName(String tableColumnName) {
		this.tableColumnName = tableColumnName;
	}

	public String getFileImportExecBatchId() {
		return fileImportExecBatchId;
	}

	public void setFileImportExecBatchId(String fileImportExecBatchId) {
		this.fileImportExecBatchId = fileImportExecBatchId;
	}

	public String getColumnValue() {
		return columnValue;
	}

	public void setColumnValue(String columnValue) {
		this.columnValue = columnValue;
	}

}
