package com.rapid.j2ee.framework.smartdbimport.resource;

import java.io.File;

import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

import com.rapid.j2ee.framework.core.charset.Charset;
import com.rapid.j2ee.framework.core.charset.CharsetType;
import com.rapid.j2ee.framework.core.charset.Charsets;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.smartdbimport.configurer.ImportResourceEncodeConfigurable;
import com.rapid.j2ee.framework.smartdbimport.configurer.ImportTableConfigurable;

public abstract class AbstractResourceLineReader implements ResourceLineReader {

	protected Resource resource;

	protected ImportTableConfigurable importTableConfigurable;

	protected int currentRowIndex;

	private String[] columnNameArrays = ObjectUtils.EMPTY_STRING_ARRAYS;

	public AbstractResourceLineReader(Resource resource,
			ImportTableConfigurable importTableConfigurable) {
		this.resource = resource;
		this.importTableConfigurable = importTableConfigurable;
		currentRowIndex = 0;
	}

	public AbstractResourceLineReader(File file,
			ImportTableConfigurable importTableConfigurable) {
		this.resource = new FileSystemResource(file);
		this.importTableConfigurable = importTableConfigurable;
		currentRowIndex = 0;
	}

	public final void parseResource() {

		this.initializeResourceLineReader();

		if (this.containsResouceColumnNamesHeader()) {
			columnNameArrays = this.doParseColumnNameArrays();
		}

	}

	protected abstract void initializeResourceLineReader();

	protected abstract String[] doParseColumnNameArrays();

	protected final void increaseCurrentRowIndex() {
		this.currentRowIndex++;
	}

	protected final boolean containsResouceColumnNamesHeader() {

		// Check if the column names are necessary to be parse.
		return importTableConfigurable.getFileSmartImportSupportType()
				.containsResouceColumnNamesHeader();
	}

	public String[] getColumnNameArrays() {

		return columnNameArrays;
	}

	public int getRowLineNumber() {

		return this.currentRowIndex;
	}

	protected Charset getCharset() {

		if (importTableConfigurable instanceof ImportResourceEncodeConfigurable) {
			return Charsets
					.getCharsetInstance(((ImportResourceEncodeConfigurable) this.importTableConfigurable)
							.getEncoding());
		}

		return Charsets.getCharsetInstance(CharsetType.CHINESE);
	}

}
