package com.rapid.j2ee.framework.smartdbimport.resource;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;

import org.springframework.core.io.Resource;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.smartdbimport.configurer.ImportTableConfigurable;

public class ExcelResourceLineParserReader extends AbstractResourceLineReader {

	private Workbook workBook;

	private Sheet workSheet;

	private int sheetTotalRowCount = 0;

	private String[] columnDataArrays = ObjectUtils.EMPTY_STRING_ARRAYS;

	public ExcelResourceLineParserReader(Resource resource,
			ImportTableConfigurable importTableConfigurable) {
		super(resource, importTableConfigurable);

	}

	public ExcelResourceLineParserReader(File file,
			ImportTableConfigurable importTableConfigurable) {
		super(file, importTableConfigurable);
	}

	@Override
	protected void initializeResourceLineReader() {
		try {

			WorkbookSettings workbookSettings = new WorkbookSettings();

			workbookSettings.setEncoding(this.getCharset().getCharset());

			this.workBook = Workbook.getWorkbook(resource.getInputStream(),
					workbookSettings);

			workSheet = this.workBook.getSheets()[0];

			sheetTotalRowCount = workSheet.getRows();

		} catch (Exception e) {
			this.close();
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}

	}

	@Override
	protected String[] doParseColumnNameArrays() {

		List<String> columnNames = new ArrayList<String>(
				workSheet.getColumns() + 1);

		for (int r = 0; r < this.getImportExcelColumnNameRowCount(); r++) {

			for (int c = 0; c < this.workSheet.getRow(r).length; c++) {
				this.addExcelColumnName(columnNames, c);
			}

			this.increaseCurrentRowIndex();
		}

		return columnNames.toArray(new String[columnNames.size()]);

	}

	public boolean hasNextColumnData() {

		while (this.hasMoreLine()) {

			columnDataArrays = this.getCellContentArraysAtCurrentRowIndex();

			this.increaseCurrentRowIndex();

			if (TypeChecker.isEmptyStringArrays(columnDataArrays)) {
				continue;
			}

			return true;

		}

		this.close();

		return false;
	}

	private int getImportExcelColumnNameRowCount() {
		return Math.min(this.importTableConfigurable
				.getFileImportDataStartRow() - 1, sheetTotalRowCount);
	}

	private void addExcelColumnName(List<String> columnNames, int columnIndex) {

		String columnName = getCellContentAtCurrentRowIndex(columnIndex);

		// Column Header Name exists in Column Name Lists
		if (columnIndex < columnNames.size()) {

			// Empty, it can be ignored.
			if (TypeChecker.isEmpty(columnName)) {
				return;
			}

			columnNames.set(columnIndex, columnName);

			return;
		}

		// Column Name is new for column name list.
		columnNames.add(columnName);
	}

	public String[] getColumnDataArrays() {

		return this.columnDataArrays;
	}

	private boolean hasMoreLine() {
		return currentRowIndex < sheetTotalRowCount;
	}

	private String[] getCellContentArraysAtCurrentRowIndex() {

		int cellColumnSize = this.workSheet.getRow(this.currentRowIndex).length;

		String[] cellContents = new String[cellColumnSize];

		for (int i = 0, j = cellColumnSize; i < j; i++) {
			cellContents[i] = this.getCellContentAtCurrentRowIndex(i);
		}

		return cellContents;
	}

	private String getCellContentAtCurrentRowIndex(int column) {
		try {
			return StringUtils.trimToEmpty(this.workSheet.getCell(column,
					this.currentRowIndex).getContents());
		} catch (Exception e) {
			return "";
		}
	}

	public void close() {
		try {
			this.workBook.close();
		} catch (Exception e) {

		}
	}

	public static void main(String[] args) {

		// ImportExcelResourceLineParserReader reader = new
		// ImportExcelResourceLineParserReader(
		// new FileSystemResource("c:\\test.xls"),
		// new ImportTableConfigurable() {
		//
		// public List<ImportTableColumnConfigurable>
		// getImportTableColumnConfigurers() {
		// // TODO Auto-generated method stub
		// return null;
		// }
		//
		// public String getOrmapJavaClassName() {
		// // TODO Auto-generated method stub
		// return null;
		// }
		//
		// public String getRevisedTableNameResolverClassName() {
		// // TODO Auto-generated method stub
		// return null;
		// }
		//
		// public String getSmartImportConfigurerDescription() {
		// // TODO Auto-generated method stub
		// return null;
		// }
		//
		// public String getSmartImportConfigurerId() {
		// // TODO Auto-generated method stub
		// return null;
		// }
		//
		// public SmartImportSupportType getSmartImportSupportType() {
		// // TODO Auto-generated method stub
		// return SmartImportSupportType.ColumnNameMapperResource;
		// }
		//
		// public int getStartImportDataRowNumber() {
		// // TODO Auto-generated method stub
		// return 3;
		// }
		//
		// });
		//
		// reader.parseResource();
		//
		// System.out.println(Arrays.toString(reader.getColumnNameArrays()));
		//
		// while (reader.hasNextColumnData()) {
		// System.out.println(reader.getRowLineNumber() + ":"
		// + Arrays.toString(reader.getColumnDataArrays()));
		// }

	}

}
