package com.rapid.j2ee.framework.smartdbimport.resource;

import org.springframework.core.io.Resource;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.io.file.FileReader;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.smartdbimport.configurer.ImportResourceItemSeparatorConfigurable;
import com.rapid.j2ee.framework.smartdbimport.configurer.ImportTableConfigurable;

public class TextResourceLineParserReader extends AbstractResourceLineReader {

	private FileReader fileReader;

	private String[] separators;

	private String[] columnDataArrays = ObjectUtils.EMPTY_STRING_ARRAYS;

	public TextResourceLineParserReader(Resource resource,
			ImportTableConfigurable importTableConfigurable) {
		super(resource, importTableConfigurable);

	}

	@Override
	protected void initializeResourceLineReader() {

		try {
			fileReader = new FileReader(this.resource.getInputStream(),
					getCharset());

			if (this.importTableConfigurable instanceof ImportResourceItemSeparatorConfigurable) {

				this.separators = ((ImportResourceItemSeparatorConfigurable) this.importTableConfigurable)
						.getResourceItemSeparators();
				return;
			}

			throw new IllegalArgumentException(
					"Please provide the text content separator or item range! ");

		} catch (Exception e) {
			this.close();
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}

	}

	@Override
	protected String[] doParseColumnNameArrays() {

		if (!this.locateByRowLine(this.importTableConfigurable
				.getFileImportDataStartRow() - 1)) {

			return ObjectUtils.EMPTY_STRING_ARRAYS;

		}

		return this.getLineContentItemArrays();
	}

	public String[] getColumnDataArrays() {
		return this.columnDataArrays;
	}

	public boolean hasNextColumnData() {

		this.locateByRowLine(this.importTableConfigurable
				.getFileImportDataStartRow() - 1);

		while (this.hasNextWithRowIndexIncreasement()) {

			columnDataArrays = this.getLineContentItemArrays();

			if (!TypeChecker.isEmptyStringArrays(this.columnDataArrays)) {
				return true;
			}

		}

		this.close();

		return false;
	}

	private boolean locateByRowLine(int rowNumber) {

		if (rowNumber < this.currentRowIndex) {
			return false;
		}

		if (rowNumber == this.currentRowIndex) {
			return true;
		}

		while (this.hasNextWithRowIndexIncreasement()) {

			if (this.currentRowIndex < rowNumber) {
				continue;
			}

			return true;
		}

		this.close();

		return false;
	}

	private boolean hasNextWithRowIndexIncreasement() {
		boolean moreline = this.fileReader.hasNext();
		this.currentRowIndex++;
		return moreline;
	}

	private String[] getLineContentItemArrays() {

		return StringUtils.splitBySeparators(this.fileReader.readLine(),
				this.separators);

	}

	public void close() {
		try {
			fileReader.close();
		} catch (Exception e) {

		}

	}

	public static void main(String[] args) {
		// ImportTextResourceLineParserReader reader = new
		// ImportTextResourceLineParserReader(
		// new FileSystemResource("c:\\test.txt"),
		// new ImportTableResourceItemSeparatorConfigurable() {
		//
		// public List<ImportTableColumnConfigurable>
		// getImportTableColumnConfigurers() {
		// // TODO Auto-generated method stub
		// return null;
		// }
		//
		// public String getOrmapJavaClassName() {
		// // TODO Auto-generated method stub
		// return null;
		// }
		//
		// public String getRevisedTableNameResolverClassName() {
		// // TODO Auto-generated method stub
		// return null;
		// }
		//
		// public String getSmartImportConfigurerDescription() {
		// // TODO Auto-generated method stub
		// return null;
		// }
		//
		// public String getSmartImportConfigurerId() {
		// // TODO Auto-generated method stub
		// return null;
		// }
		//
		// public SmartImportSupportType getSmartImportSupportType() {
		// // TODO Auto-generated method stub
		// return SmartImportSupportType.ColumnNameMapperResource;
		// }
		//
		// public int getStartImportDataRowNumber() {
		// // TODO Auto-generated method stub
		// return 2;
		// }
		//
		// public String getResourceItemSeparator() {
		// // TODO Auto-generated method stub
		// return " ";
		// }
		//
		// });
		//
		// reader.parseResource();
		//
		// System.out.println(Arrays.toString(reader.getColumnNameArrays()));
		// while (reader.hasNextColumnData()) {
		// System.out.println(reader.getRowLineNumber() + ":"
		// + Arrays.toString(reader.getColumnDataArrays()));
		// }
	}

}
