package com.rapid.j2ee.framework.smartdbimport.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.utils.CollectionsUtil;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.smartdbimport.SmartResourceImportDatabaseExecutor;
import com.rapid.j2ee.framework.smartdbimport.configurer.ImportTableColumnConfigurable;
import com.rapid.j2ee.framework.smartdbimport.configurer.ImportTableColumnIndexMapperConfigurable;
import com.rapid.j2ee.framework.smartdbimport.support.SmartResourceImportResult.ErrorInformation;
import com.rapid.j2ee.framework.smartdbimport.support.SmartResourceImportResult.ErrorType;

public class SmartResourceImportFormatGeneralValidator implements
		SmartResourceImportFormatValidator {

	private SmartResourceImportDatabaseExecutor smartResourceImportDatabaseExecutor;

	private Map<String, Integer> javaFieldIndexOfResourceColumnMapper = null;

	public SmartResourceImportFormatGeneralValidator(
			SmartResourceImportDatabaseExecutor smartResourceImportDatabaseExecutor) {
		this.smartResourceImportDatabaseExecutor = smartResourceImportDatabaseExecutor;
		javaFieldIndexOfResourceColumnMapper = new HashMap<String, Integer>();
	}

	public boolean validate() {

		System.out.println("validate() called...");

		if (!containsResouceColumnNamesHeader()) {

			System.out.println("no contains column name as headers....");

			this.prepareDirectColumnIndexMapper();

			return true;
		}

		if (!this.checkIfAllColumnNamesUnique()) {
			return false;
		}

		return this.locateIndexOfResourceColumnNamesMapper();
	}

	private void prepareDirectColumnIndexMapper() {

		for (ImportTableColumnConfigurable importTableColumnConfigurable : this.smartResourceImportDatabaseExecutor
				.getImportTableConfigurable()
				.getImportTableRealColumnConfigurers()) {

			if (importTableColumnConfigurable instanceof ImportTableColumnIndexMapperConfigurable) {

				javaFieldIndexOfResourceColumnMapper
						.put(
								importTableColumnConfigurable
										.getJavaFieldName(),
								((ImportTableColumnIndexMapperConfigurable) importTableColumnConfigurable)
										.getTableColumnIndex());

				continue;
			}

			Assert
					.isTrue(
							false,
							"The Table Column ["
									+ importTableColumnConfigurable
											.getTableColumnName()
									+ "] must be implemented ImportTableColumnIndexMapperConfigurable!");

		}
	}

	private boolean locateIndexOfResourceColumnNamesMapper() {

		for (ImportTableColumnConfigurable tableColumn : this.smartResourceImportDatabaseExecutor
				.getImportTableConfigurable()
				.getImportTableRealColumnConfigurers()) {

			this.addIndexOfResourceColumnNameMapper(tableColumn);
		}

		return !this.smartResourceImportDatabaseExecutor
				.getSmartResourceImportResult().hasImportResourceFormatErrors();

	}

	private void addIndexOfResourceColumnNameMapper(
			ImportTableColumnConfigurable tableColumn) {

		int columnIndex = -1;

		boolean foundItem = false;

		for (String columName : this.smartResourceImportDatabaseExecutor
				.getResourceLineReader().getColumnNameArrays()) {

			columnIndex++;

			if (StringUtils.equalsIgnoreCase(tableColumn.getTableColumnName(),
					columName)) {
				javaFieldIndexOfResourceColumnMapper.put(tableColumn
						.getJavaFieldName(), columnIndex);
				foundItem = true;
				break;
			}
		}

		if (!foundItem) {
			this.smartResourceImportDatabaseExecutor
					.getSmartResourceImportResult()
					.addImportResourceFormatError(
							ErrorInformation.valueOf("The table column ["
									+ tableColumn.getTableColumnName()
									+ "] cannot find resource column mapper!",
									ErrorType.ColumnNameMissMapper, tableColumn
											.getTableColumnName()));
		}

	}

	private boolean checkIfAllColumnNamesUnique() {

		List<String> columNames = new ArrayList<String>(
				new HashSet(
						CollectionsUtil
								.getItemsOfOverOccurredCount(
										Arrays
												.asList(this.smartResourceImportDatabaseExecutor
														.getResourceLineReader()
														.getColumnNameArrays()),
										1)));

		for (String columName : columNames) {

			smartResourceImportDatabaseExecutor.getSmartResourceImportResult()
					.addImportResourceFormatError(
							ErrorInformation.valueOf("The colum name["
									+ columName + "] is duplicated in file.",
									ErrorType.ColumNameDuplicated, columName));
		}

		return TypeChecker.isEmpty(columNames);
	}

	private boolean containsResouceColumnNamesHeader() {

		return this.smartResourceImportDatabaseExecutor
				.getImportTableConfigurable().getFileSmartImportSupportType()
				.containsResouceColumnNamesHeader();

	}

	public Map<String, Integer> getJavaFieldIndexOfResourceColumnMapper() {

		return this.javaFieldIndexOfResourceColumnMapper;
	}

	public Integer getResourceColumnIndex(String javaFieldName) {

		return javaFieldIndexOfResourceColumnMapper.get(javaFieldName);
	}
}
