package com.rapid.j2ee.framework.smartdbimport.support;

import java.io.Serializable;
import java.util.List;

import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.smartdbimport.configurer.AbstractImportTableConfigurable;
import com.rapid.j2ee.framework.smartdbimport.configurer.ImportTableColumnConfigurable;
import com.rapid.j2ee.framework.smartdbimport.configurer.ImportTableColumnDataValidator;
import com.rapid.j2ee.framework.smartdbimport.error.SmartTableColumnDataValidationErrorReceiver;

public class SmartResourceImportJavaBeanVerification implements
		SmartResourceImportJavaBeanVerifiable {

	private AbstractImportTableConfigurable importTableConfigurable;

	private SmartResourceImportFormatValidator smartResourceImportFormatValidator;

	private ImportTableColumnDataValidator lastImportTableColumnDataValidator;

	private Serializable finalJavaBean = null;

	private Serializable originalJavaBean = null;

	private boolean passJavaBeanVerfication;

	public SmartResourceImportJavaBeanVerification(
			AbstractImportTableConfigurable importTableConfigurable,
			SmartResourceImportFormatValidator smartResourceImportFormatValidator) {
		this.importTableConfigurable = importTableConfigurable;
		this.smartResourceImportFormatValidator = smartResourceImportFormatValidator;
	}

	public boolean verify(Serializable javaBean) {

		this.originalJavaBean = javaBean;

		finalJavaBean = (Serializable) ObjectUtils
				.cloneObject(originalJavaBean);

		SmartResourceLineNumberAware beanLineNumberAware = (SmartResourceLineNumberAware) this.originalJavaBean;

		passJavaBeanVerfication = true;

		for (ImportTableColumnConfigurable importTableColumnConfigurable : this.importTableConfigurable
				.getImportTableRealColumnConfigurers()) {

			lastImportTableColumnDataValidator = null;

			String columnValue = BeanUtils.getProperty(javaBean,
					importTableColumnConfigurable.getJavaFieldName());

			if (!this.verifyTableColumnDataTypeValidators(beanLineNumberAware,
					columnValue, importTableColumnConfigurable,
					importTableConfigurable
							.getGeneralImportTableColumnDataValidators())) {

				passJavaBeanVerfication = false;

				continue;
			}

			if (!this.verifyTableColumnDataTypeValidators(beanLineNumberAware,
					columnValue, importTableColumnConfigurable,
					importTableColumnConfigurable
							.getImportTableColumnDataValidators())) {
				passJavaBeanVerfication = false;

				continue;
			}

			if (!TypeChecker.isNull(lastImportTableColumnDataValidator)) {
				BeanUtils.setProperty(finalJavaBean,
						importTableColumnConfigurable.getJavaFieldName(),
						lastImportTableColumnDataValidator
								.getSmartTableColumnDataTypeConverter()
								.convertWhenSucess(columnValue));
			}

		}

		return passJavaBeanVerfication;

	}

	public Serializable getConvertedJavaBean() {

		return passJavaBeanVerfication ? finalJavaBean : originalJavaBean;
	}

	private boolean verifyTableColumnDataTypeValidators(
			SmartResourceLineNumberAware beanLineNumberAware,
			String columnValue,
			ImportTableColumnConfigurable importTableColumnConfigurable,
			List<ImportTableColumnDataValidator> importTableColumnDataValidators) {

		if (TypeChecker.isEmpty(importTableColumnDataValidators)) {
			return true;
		}

		SmartTableColumnDataValidationErrorReceiver smartTableColumnDataTypeErrorReceiver = (SmartTableColumnDataValidationErrorReceiver) beanLineNumberAware;

		for (ImportTableColumnDataValidator importTableColumnDataValidator : importTableColumnDataValidators) {

			lastImportTableColumnDataValidator = importTableColumnDataValidator;

			if (!importTableColumnDataValidator
					.getSmartTableColumnDataTypeValidator()
					.validate(
							beanLineNumberAware.getRowNumber(),
							smartResourceImportFormatValidator
									.getResourceColumnIndex(importTableColumnConfigurable
											.getJavaFieldName()), columnValue,
							beanLineNumberAware,
							smartTableColumnDataTypeErrorReceiver,
							importTableColumnConfigurable,
							importTableColumnDataValidator)) {

				BeanUtils.setProperty(beanLineNumberAware,
						importTableColumnConfigurable.getJavaFieldName(),
						importTableColumnDataValidator
								.getSmartTableColumnDataTypeConverter()
								.convertEvenError(columnValue));

				return false;
			}

		}

		return true;

	}

}
