package com.rapid.j2ee.framework.smartdbimport.support;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class SmartResourceImportResult {

	private List<ErrorInformation> resourceFormatErrors;

	public SmartResourceImportResult() {
		resourceFormatErrors = new ArrayList<ErrorInformation>();
	}

	public void addImportResourceFormatError(ErrorInformation error) {
		resourceFormatErrors.add(error);
	}

	public List<ErrorInformation> getImportResourceFormatError() {
		return this.resourceFormatErrors;
	}

	public boolean hasImportResourceFormatErrors() {
		return !TypeChecker.isEmpty(this.resourceFormatErrors);
	}

	public static enum ErrorType {

		ColumNameDuplicated, ColumnNameMissMapper, DataFieldTypeValidationError, DataFieldTypeMandatoryError,

		DataFieldTypeOverMaxLengthError, DataFieldTypeIllegalDecimalError, DataFieldTypeRestrictedDecimalError, DataFieldTypeRestrictedIntegerError,

		DataFieldTypeLessMinRangeError, DataFieldTypeOverMaxRangeError, DataFieldTypeDateTimeError, DataFieldTypeDateTimeMoreError

	}

	public static class ErrorInformation {

		private String[] errorPointParameters = ObjectUtils.EMPTY_STRING_ARRAYS;

		private String errorMessage;

		private ErrorType errorType;

		public static ErrorInformation valueOf(String errorMessage,
				ErrorType errorType, String... errorPointParameters) {
			return new ErrorInformation(errorMessage, errorType,
					errorPointParameters);
		}

		protected ErrorInformation(String errorMessage, ErrorType errorType,
				String... errorPointParameters) {

			this.errorMessage = errorMessage;

			this.errorType = errorType;

			if (TypeChecker.isEmpty(errorPointParameters)) {
				return;
			}

			this.errorPointParameters = errorPointParameters;
		}

		public String getErrorMessage() {
			return errorMessage;
		}

		public String[] getErrorPointParameters() {
			return errorPointParameters;
		}

		public ErrorType getErrorType() {
			return errorType;
		}

		public String toString() {
			return ToStringBuilder.reflectionToString(this);
		}

		public void reviseErrorMessage(String errorMessage) {
			this.errorMessage = errorMessage;
		}

	}

}
