package com.rapid.j2ee.framework.smartdbimport.support;

import java.lang.reflect.Field;

import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.core.reflect.InvokeUtils;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.smartdbimport.annotation.SmartImportResourceExecuteBatchId;
import com.rapid.j2ee.framework.smartdbimport.configurer.AbstractImportTableConfigurable;
import com.rapid.j2ee.framework.smartdbimport.configurer.ImportTableColumnConfigurable;
import com.rapid.j2ee.framework.smartdbimport.configurer.ImportTableVirtualColumnMapperConfigurable;
import com.rapid.j2ee.framework.smartdbimport.error.SmartTableColumnDataValidationErrorReceiver;
import com.rapid.j2ee.framework.smartdbimport.execute.logger.SmartImportExecuteLoggable;
import com.rapid.j2ee.framework.smartdbimport.resource.ResourceLineReader;

public class SmartResourceOrmJavaBeanBuilder {

	private AbstractImportTableConfigurable importTableConfigurable;

	private SmartResourceImportFormatValidator smartResourceImportFormatValidator;

	private boolean columnAbsentDataFound = false;

	private boolean orMapJavaBeanClassNameAvaiable;

	public SmartResourceOrmJavaBeanBuilder(
			AbstractImportTableConfigurable importTableConfigurable,
			SmartResourceImportFormatValidator smartResourceImportFormatValidator) {
		this.importTableConfigurable = importTableConfigurable;
		this.smartResourceImportFormatValidator = smartResourceImportFormatValidator;
		orMapJavaBeanClassNameAvaiable = false;

	}

	public Object buildByTableRealColumnConfigurers(
			ResourceLineReader resourceLineReader) {

		validateOrmJavaBeanProperties();

		columnAbsentDataFound = false;

		Object ormJavaBean = ConstructorUtils
				.newInstance(importTableConfigurable.getOrmapJavaClassName());

		this.bindResourceDataByTableRealColumnConfigurers(resourceLineReader
				.getRowLineNumber(), ormJavaBean, resourceLineReader
				.getColumnDataArrays());

		return ormJavaBean;

	}

	public Object appendTableVirtualColumnInformations(Object ormJavaBean,
			ResourceLineReader resourceLineReader) {

		this.bindResourceDataByTableVirtualColumnConfigurers(ormJavaBean,
				resourceLineReader.getColumnDataArrays());

		return ormJavaBean;

	}

	public void appendResourceExecuteBatchId(Object ormJavaBean,
			SmartImportExecuteLoggable smartImportExecuteLoggable) {

		Field mainIdField = ClassUtils.getFieldsByAnnotation(ormJavaBean
				.getClass(), SmartImportResourceExecuteBatchId.class)[0];

		InvokeUtils.setField(ormJavaBean, mainIdField,
				smartImportExecuteLoggable.getFileImportExecBatchId());

	}

	private void validateOrmJavaBeanProperties() {

		if (orMapJavaBeanClassNameAvaiable) {
			return;
		}

		Assert.hasLength(importTableConfigurable.getOrmapJavaClassName(),
				"Please provide OR Map Java Class Name!");

		try {

			Class beanClass = Class.forName(importTableConfigurable
					.getOrmapJavaClassName());

			Assert.isTrue(ClassUtils.isAssignable(beanClass,
					SmartResourceLineNumberAware.class),
					"Sorry, The java bean ["
							+ importTableConfigurable.getOrmapJavaClassName()
							+ "] must implement "
							+ SmartResourceLineNumberAware.class.getName());

			Assert.isTrue(ClassUtils.isAssignable(beanClass,
					SmartTableColumnDataValidationErrorReceiver.class),
					"Sorry, The java bean ["
							+ importTableConfigurable.getOrmapJavaClassName()
							+ "] must implement "
							+ SmartTableColumnDataValidationErrorReceiver.class
									.getName());

			Assert
					.noNullElements(
							ClassUtils.getAllFieldsAsClassByAnnotation(
									beanClass,
									SmartImportResourceExecuteBatchId.class),
							"Please setup a annotation [SmartImportResourceMainStatTableId] at ormap class' field ! Class:"
									+ importTableConfigurable
											.getOrmapJavaClassName());

			orMapJavaBeanClassNameAvaiable = true;

		} catch (ClassNotFoundException e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}

	}

	public boolean isColumnAbsentDataFound() {
		return columnAbsentDataFound;
	}

	private void bindResourceDataByTableRealColumnConfigurers(int rowNumber,
			Object ormJavaBean, String[] columnDataArrays) {

		SmartResourceLineNumberAware ormJavaBeanLineAware = (SmartResourceLineNumberAware) ormJavaBean;

		ormJavaBeanLineAware.setRowNumber(rowNumber);

		for (ImportTableColumnConfigurable realTableColumnConfigurer : this.importTableConfigurable
				.getImportTableRealColumnConfigurers()) {

			ormJavaBeanLineAware.addFieldColumnIndex(realTableColumnConfigurer
					.getJavaFieldName(), smartResourceImportFormatValidator
					.getJavaFieldIndexOfResourceColumnMapper().get(
							realTableColumnConfigurer.getJavaFieldName()));

			BeanUtils.setProperty(ormJavaBean, realTableColumnConfigurer
					.getJavaFieldName(), this.getColumnDataByJavaFieldName(
					realTableColumnConfigurer, columnDataArrays));
		}
	}

	private void bindResourceDataByTableVirtualColumnConfigurers(
			Object ormJavaBean, String[] columnDataArrays) {

		for (ImportTableVirtualColumnMapperConfigurable tableVirtualColumnConfigurer : this.importTableConfigurable
				.getImportTableVirtualColumnConfigurers()) {

			BeanUtils.setProperty(ormJavaBean, tableVirtualColumnConfigurer
					.getJavaFieldName(), tableVirtualColumnConfigurer
					.getImportTableVirtualColumnMapperDataHandler()
					.getVirtualColumnData(ormJavaBean,
							tableVirtualColumnConfigurer, columnDataArrays));
		}
	}

	private String getColumnDataByJavaFieldName(
			ImportTableColumnConfigurable realTableColumnConfigurer,
			String[] columnDataArrays) {

		int columnIndex = smartResourceImportFormatValidator
				.getJavaFieldIndexOfResourceColumnMapper().get(
						realTableColumnConfigurer.getJavaFieldName());

		if (columnIndex >= columnDataArrays.length) {
			columnAbsentDataFound = true;
			return null;
		}

		return StringUtils.trimToEmpty(columnDataArrays[columnIndex]);

	}
}
