package com.rapid.j2ee.framework.smartdbimport.support;

import java.util.Map;

import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.collections.HashMapAsKeyIgnoreCase;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.smartdbimport.converter.SmartTableColumnDataTypeConverter;
import com.rapid.j2ee.framework.smartdbimport.converter.SmartTableColumnDataTypeDateTimeConverter;
import com.rapid.j2ee.framework.smartdbimport.converter.SmartTableColumnDataTypeLengthConverter;
import com.rapid.j2ee.framework.smartdbimport.validator.SmartTableColumnDataTypeDateTimeValidator;
import com.rapid.j2ee.framework.smartdbimport.validator.SmartTableColumnDataTypeDecimalRangeValidator;
import com.rapid.j2ee.framework.smartdbimport.validator.SmartTableColumnDataTypeDecimalValidator;
import com.rapid.j2ee.framework.smartdbimport.validator.SmartTableColumnDataTypeIntegerValidator;
import com.rapid.j2ee.framework.smartdbimport.validator.SmartTableColumnDataTypeLengthValidator;
import com.rapid.j2ee.framework.smartdbimport.validator.SmartTableColumnDataTypeMandatoryValidator;
import com.rapid.j2ee.framework.smartdbimport.validator.SmartTableColumnDataTypeValidator;

public class SmartTableColumnDataTypeValidatorConverterDefaultRegistry
		implements SmartTableColumnDataTypeValidatorConverterRegistry {

	private Map<String, SmartTableColumnDataTypeValidator> smartTableColumnDataValidatorTypeMapper = null;

	private Map<String, SmartTableColumnDataTypeConverter> smartTableColumnDataConverterTypeMapper = null;

	public SmartTableColumnDataTypeValidatorConverterDefaultRegistry() {

		smartTableColumnDataValidatorTypeMapper = new HashMapAsKeyIgnoreCase<SmartTableColumnDataTypeValidator>();
		smartTableColumnDataConverterTypeMapper = new HashMapAsKeyIgnoreCase<SmartTableColumnDataTypeConverter>();

		this.initValidatorAndConverters();
	}

	protected void initValidatorAndConverters() {

		this.registry("SmartTableColumnDataTypeLength",
				new SmartTableColumnDataTypeLengthValidator(),
				new SmartTableColumnDataTypeLengthConverter());

		this.registry("SmartTableColumnDataTypeMandatory",
				new SmartTableColumnDataTypeMandatoryValidator(), null);

		this.registry("SmartTableColumnDataTypeDecimal",
				new SmartTableColumnDataTypeDecimalValidator(), null);

		this.registry("SmartTableColumnDataTypeInteger",
				new SmartTableColumnDataTypeIntegerValidator(), null);

		this.registry("SmartTableColumnDataTypeDecimalRange",
				new SmartTableColumnDataTypeDecimalRangeValidator(), null);

		this.registry("SmartTableColumnDataTypeDateTime",
				new SmartTableColumnDataTypeDateTimeValidator(),
				new SmartTableColumnDataTypeDateTimeConverter());

	}

	public void registry(String type,
			SmartTableColumnDataTypeValidator validator) {
		this.registry(type, validator, null);
	}

	public void registry(String type,
			SmartTableColumnDataTypeValidator validator,
			SmartTableColumnDataTypeConverter converter) {

		Assert.hasText(type);
		Assert.notNull(validator, "Please provide a validator for type[" + type
				+ "]");

		if (!smartTableColumnDataValidatorTypeMapper.containsKey(this
				.getValidatorType(type))) {
			smartTableColumnDataValidatorTypeMapper.put(this
					.getValidatorType(type), validator);
		}

		if (TypeChecker.isNull(converter)) {
			return;
		}

		if (!smartTableColumnDataConverterTypeMapper.containsKey(this
				.getConverterType(type))) {
			smartTableColumnDataConverterTypeMapper.put(this
					.getConverterType(type), converter);
		}

	}

	public boolean containsValidator(String type) {

		return smartTableColumnDataValidatorTypeMapper.containsKey(this
				.getValidatorType(type));
	}

	public boolean containsConverter(String type) {

		System.out.println("containsConverter type ======= "
				+ type
				+ " find:"
				+ smartTableColumnDataConverterTypeMapper.containsKey(this
						.getConverterType(type)));

		return smartTableColumnDataConverterTypeMapper.containsKey(this
				.getConverterType(type));
	}

	public SmartTableColumnDataTypeValidator getSmartTableColumnDataTypeValidatorByType(
			String type) {

		return smartTableColumnDataValidatorTypeMapper.get(this
				.getValidatorType(type));
	}

	public SmartTableColumnDataTypeConverter getSmartTableColumnDataTypeConverterByType(
			String type) {

		return smartTableColumnDataConverterTypeMapper.get(this
				.getConverterType(type));
	}

	public String getValidatorType(String type) {
		return getType(type, "Validator");
	}

	public String getConverterType(String type) {
		return getType(type, "Converter");
	}

	public String getType(String type, String endWithType) {

		type = StringUtils.trimToEmpty(type);

		if (!type.endsWith(endWithType)) {
			type = type + endWithType;
		}

		return type;

	}
}
