package com.rapid.j2ee.framework.smartdbimport.validator;

import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.utils.NumberUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.smartdbimport.configurer.ImportTableColumnConfigurable;
import com.rapid.j2ee.framework.smartdbimport.configurer.ImportTableColumnDataValidator;
import com.rapid.j2ee.framework.smartdbimport.converter.SmartTableColumnDataTypeConverterParametersHolder;
import com.rapid.j2ee.framework.smartdbimport.error.SmartTableColumnDataValidationErrorReceiver;

public abstract class AbstractSmartTableColumnDataTypeValidator implements
		SmartTableColumnDataTypeValidator {

	public boolean validate(
			int rowNumber,
			int columnNumber,
			String columnValue,
			Object javaBean,
			SmartTableColumnDataValidationErrorReceiver smartTableColumnDataTypeErrorReceiver,
			ImportTableColumnConfigurable importTableColumnConfigurable,
			ImportTableColumnDataValidator importTableColumnDataValidator) {

		SmartTableColumnDataTypeConverterParametersHolder.getInstance().clear();

		if (TypeChecker.isEmpty(columnValue)) {
			return true;
		}

		return this.doValidate(rowNumber, columnNumber + 1, columnValue,
				javaBean, smartTableColumnDataTypeErrorReceiver,
				importTableColumnConfigurable, importTableColumnDataValidator);
	}

	public abstract boolean doValidate(
			int rowNumber,
			int columnNumber,
			String columnValue,
			Object javaBean,
			SmartTableColumnDataValidationErrorReceiver smartTableColumnDataTypeErrorReceiver,
			ImportTableColumnConfigurable importTableColumnConfigurable,
			ImportTableColumnDataValidator importTableColumnDataValidator);

	protected final boolean containParameter(
			ImportTableColumnDataValidator importTableColumnDataValidator,
			String key) {
		return importTableColumnDataValidator.getParameters().containsKey(key);
	}

	protected final int getParameterPlusIntegerValue(
			ImportTableColumnDataValidator importTableColumnDataValidator,
			String key, Integer defValue) {

		String value = getParameterValue(importTableColumnDataValidator, key,
				defValue);

		if (!TypeChecker.isEmpty(value)) {
			Assert.isTrue(TypeChecker.isPlusInteger(value),
					"Please provide a plus int value as parameter key [ " + key
							+ "]");
		}

		return NumberUtils.parseInt(value);

	}

	protected final int getParameterPlusIntegerValue(
			ImportTableColumnDataValidator importTableColumnDataValidator,
			String key) {
		return this.getParameterPlusIntegerValue(
				importTableColumnDataValidator, key, null);
	}

	protected final double getParameterDoubleValue(
			ImportTableColumnDataValidator importTableColumnDataValidator,
			String key) {
		return this.getParameterDoubleValue(importTableColumnDataValidator,
				key, null);
	}

	protected final double getParameterDoubleValue(
			ImportTableColumnDataValidator importTableColumnDataValidator,
			String key, Double defValue) {

		String value = getParameterValue(importTableColumnDataValidator, key,
				defValue);

		if (!TypeChecker.isEmpty(value)) {
			Assert.isTrue(TypeChecker.isNumber(value),
					"Please provide a double value as parameter key [ " + key
							+ "]");
		}

		return NumberUtils.parseDouble(value);

	}

	protected final String getParameterValue(
			ImportTableColumnDataValidator importTableColumnDataValidator,
			String key) {

		return this
				.getParameterValue(importTableColumnDataValidator, key, null);

	}

	protected final String getParameterValue(
			ImportTableColumnDataValidator importTableColumnDataValidator,
			String key, Object def) {

		String value = importTableColumnDataValidator.getParameters()
				.getProperty(key);

		if (TypeChecker.isNull(def)) {
			Assert.isTrue(!TypeChecker.isEmpty(value),
					"Please provide not empty value as parameter key [ " + key
							+ "]");
		}

		return StringUtils.trimToEmpty(value, String.valueOf(def));

	}

}
