package com.rapid.j2ee.framework.smartdbimport.validator;

import com.rapid.j2ee.framework.core.utils.DateTimeUtils;
import com.rapid.j2ee.framework.core.utils.NumberUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.core.utils.DateTimeUtils.DateTimeBean;
import com.rapid.j2ee.framework.core.utils.TypeChecker.TypeMoreChecker;
import com.rapid.j2ee.framework.core.utils.support.DateTimeFormat;
import com.rapid.j2ee.framework.smartdbimport.configurer.ImportTableColumnConfigurable;
import com.rapid.j2ee.framework.smartdbimport.configurer.ImportTableColumnDataValidator;
import com.rapid.j2ee.framework.smartdbimport.converter.SmartTableColumnDataTypeConverterParametersHolder;
import com.rapid.j2ee.framework.smartdbimport.error.SmartTableColumnDataValidationErrorReceiver;
import com.rapid.j2ee.framework.smartdbimport.support.SmartResourceImportResult.ErrorInformation;
import com.rapid.j2ee.framework.smartdbimport.support.SmartResourceImportResult.ErrorType;

public class SmartTableColumnDataTypeDateTimeValidator extends
		AbstractSmartTableColumnDataTypeValidator {

	public static final String TABLE_COLUMN_DATA_DATETIME_FORMAT_KEY = "datetime-format";

	public static ThreadLocal<Boolean> dateTimeTypeMoreCheckingError = new ThreadLocal<Boolean>() {
		@Override
		protected Boolean initialValue() {

			return Boolean.FALSE;
		}
	};

	public static final TypeMoreChecker dateTimeTypeMoreChecker = new TypeMoreChecker() {

		public boolean validate(Object... parameters) {

			DateTimeBean dateTimeBean = (DateTimeBean) parameters[parameters.length - 1];

			dateTimeTypeMoreCheckingError.set(false);

			if (NumberUtils.parseInt(dateTimeBean.getYear(), 1900) < 1900) {

				dateTimeTypeMoreCheckingError.set(true);

				return false;
			}

			return true;
		}

	};

	@Override
	public boolean doValidate(
			int rowNumber,
			int columnNumber,
			String columnValue,
			Object javaBean,
			SmartTableColumnDataValidationErrorReceiver smartTableColumnDataTypeErrorReceiver,
			ImportTableColumnConfigurable importTableColumnConfigurable,
			ImportTableColumnDataValidator importTableColumnDataValidator) {

		try {

			String[] formats = StringUtils.splitBySeparator(DateTimeFormat
					.resolveDateTimeFormat(this.getParameterValue(
							importTableColumnDataValidator,
							TABLE_COLUMN_DATA_DATETIME_FORMAT_KEY)), ",");

			for (String format : formats) {

				ErrorInformation errorInformation = this
						.doValidateByPerDateFormat(rowNumber, columnNumber,
								columnValue, javaBean, format,
								importTableColumnConfigurable,
								importTableColumnDataValidator);

				if (TypeChecker.isNull(errorInformation)) {
					return true;
				}

				if (errorInformation.getErrorType() == ErrorType.DataFieldTypeDateTimeMoreError) {

					smartTableColumnDataTypeErrorReceiver
							.addTableColumnDataTypeError(rowNumber,
									columnNumber, columnValue,
									importTableColumnConfigurable,
									errorInformation);

					return false;
				}

			}

			smartTableColumnDataTypeErrorReceiver
					.addTableColumnDataTypeError(
							rowNumber,
							columnNumber,
							columnValue,
							importTableColumnConfigurable,
							ErrorInformation
									.valueOf(
											importTableColumnDataValidator
													.getErrorMessageFormat(),
											ErrorType.DataFieldTypeDateTimeError,
											importTableColumnConfigurable
													.getTableColumnName(),
											String.valueOf(rowNumber),
											String.valueOf(columnNumber),
											columnValue,
											DateTimeFormat
													.resolveDateTimeFormat(this
															.getParameterValue(
																	importTableColumnDataValidator,
																	TABLE_COLUMN_DATA_DATETIME_FORMAT_KEY))));

			return false;

		} finally {
			dateTimeTypeMoreCheckingError.remove();
		}

	}

	private ErrorInformation doValidateByPerDateFormat(int rowNumber,
			int columnNumber, String columnValue, Object javaBean,
			String dateFormat,
			ImportTableColumnConfigurable importTableColumnConfigurable,
			ImportTableColumnDataValidator importTableColumnDataValidator) {

		if (!TypeChecker.isDateTime(columnValue, dateFormat,
				dateTimeTypeMoreChecker)) {

			return ErrorInformation.valueOf(importTableColumnDataValidator
					.getErrorMessageFormat(), dateTimeTypeMoreCheckingError
					.get() ? ErrorType.DataFieldTypeDateTimeMoreError
					: ErrorType.DataFieldTypeDateTimeError,
					importTableColumnConfigurable.getTableColumnName(), String
							.valueOf(rowNumber), String.valueOf(columnNumber),
					columnValue, dateFormat);

		}

		SmartTableColumnDataTypeConverterParametersHolder.getInstance()
				.setParameters(
						DateTimeUtils.parseDateTimeByFormat(columnValue,
								dateFormat), dateFormat);

		return null;
	}
}
