package com.rapid.j2ee.framework.smartdbimport.validator;

import com.rapid.j2ee.framework.core.utils.NumberUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.smartdbimport.configurer.ImportTableColumnConfigurable;
import com.rapid.j2ee.framework.smartdbimport.configurer.ImportTableColumnDataValidator;
import com.rapid.j2ee.framework.smartdbimport.error.SmartTableColumnDataValidationErrorReceiver;
import com.rapid.j2ee.framework.smartdbimport.support.SmartResourceImportResult.ErrorInformation;
import com.rapid.j2ee.framework.smartdbimport.support.SmartResourceImportResult.ErrorType;

public class SmartTableColumnDataTypeDecimalRangeValidator extends
		AbstractSmartTableColumnDataTypeValidator {

	public static final String TABLE_COLUMN_DATA_RANGE_MAX_VALUE_KEY = "max-value";

	public static final String TABLE_COLUMN_DATA_RANGE_MIN_VALUE_KEY = "min-value";

	public static final String TABLE_COLUMN_DATA_RANGE_EQ_MAX_VALUE_KEY = "max-eq-value";

	public static final String TABLE_COLUMN_DATA_RANGE_EQ_MIN_VALUE_KEY = "min-eq-value";

	private static final double DOUBLE_COMPARABLE_EQUALS_VALUE = 0.0000000000000000000000000000000000000000000000000000000000001;

	@Override
	public boolean doValidate(
			int rowNumber,
			int columnNumber,
			String columnValue,
			Object javaBean,
			SmartTableColumnDataValidationErrorReceiver smartTableColumnDataTypeErrorReceiver,
			ImportTableColumnConfigurable importTableColumnConfigurable,
			ImportTableColumnDataValidator importTableColumnDataValidator) {

		double columnDoubleValue = NumberUtils.parseDouble(StringUtils.remove(
				columnValue, ","));

		if (this.containParameter(importTableColumnDataValidator,
				TABLE_COLUMN_DATA_RANGE_MIN_VALUE_KEY)) {

			if (Math.abs(this.getParameterDoubleValue(
					importTableColumnDataValidator,
					TABLE_COLUMN_DATA_RANGE_MIN_VALUE_KEY)
					- columnDoubleValue) <= DOUBLE_COMPARABLE_EQUALS_VALUE
					||

					this.getParameterDoubleValue(
							importTableColumnDataValidator,
							TABLE_COLUMN_DATA_RANGE_MIN_VALUE_KEY)
							- columnDoubleValue >= DOUBLE_COMPARABLE_EQUALS_VALUE) {

				this.addErrorInformation(
						ErrorType.DataFieldTypeLessMinRangeError, rowNumber,
						columnNumber, columnValue, this.getParameterValue(
								importTableColumnDataValidator,
								TABLE_COLUMN_DATA_RANGE_MIN_VALUE_KEY),
						smartTableColumnDataTypeErrorReceiver,
						importTableColumnConfigurable,
						importTableColumnDataValidator);

				return false;

			}
		}

		if (this.containParameter(importTableColumnDataValidator,
				TABLE_COLUMN_DATA_RANGE_MAX_VALUE_KEY)) {
			if (Math.abs(this.getParameterDoubleValue(
					importTableColumnDataValidator,
					TABLE_COLUMN_DATA_RANGE_MAX_VALUE_KEY)
					- columnDoubleValue) <= DOUBLE_COMPARABLE_EQUALS_VALUE
					||

					columnDoubleValue
							- this.getParameterDoubleValue(
									importTableColumnDataValidator,
									TABLE_COLUMN_DATA_RANGE_MAX_VALUE_KEY) >= DOUBLE_COMPARABLE_EQUALS_VALUE) {

				this.addErrorInformation(
						ErrorType.DataFieldTypeOverMaxRangeError, rowNumber,
						columnNumber, columnValue, this.getParameterValue(
								importTableColumnDataValidator,
								TABLE_COLUMN_DATA_RANGE_MAX_VALUE_KEY),
						smartTableColumnDataTypeErrorReceiver,
						importTableColumnConfigurable,
						importTableColumnDataValidator);

				return false;

			}
		}

		if (this.containParameter(importTableColumnDataValidator,
				TABLE_COLUMN_DATA_RANGE_EQ_MIN_VALUE_KEY)) {

			if (this.getParameterDoubleValue(importTableColumnDataValidator,
					TABLE_COLUMN_DATA_RANGE_EQ_MIN_VALUE_KEY)
					- columnDoubleValue >= DOUBLE_COMPARABLE_EQUALS_VALUE) {

				this.addErrorInformation(
						ErrorType.DataFieldTypeLessMinRangeError, rowNumber,
						columnNumber, columnValue, this.getParameterValue(
								importTableColumnDataValidator,
								TABLE_COLUMN_DATA_RANGE_EQ_MIN_VALUE_KEY),
						smartTableColumnDataTypeErrorReceiver,
						importTableColumnConfigurable,
						importTableColumnDataValidator);

				return false;

			}
		}

		if (this.containParameter(importTableColumnDataValidator,
				TABLE_COLUMN_DATA_RANGE_EQ_MAX_VALUE_KEY)) {
			if (columnDoubleValue
					- this.getParameterDoubleValue(
							importTableColumnDataValidator,
							TABLE_COLUMN_DATA_RANGE_EQ_MAX_VALUE_KEY) > DOUBLE_COMPARABLE_EQUALS_VALUE) {

				this.addErrorInformation(
						ErrorType.DataFieldTypeOverMaxRangeError, rowNumber,
						columnNumber, columnValue, this.getParameterValue(
								importTableColumnDataValidator,
								TABLE_COLUMN_DATA_RANGE_EQ_MAX_VALUE_KEY),
						smartTableColumnDataTypeErrorReceiver,
						importTableColumnConfigurable,
						importTableColumnDataValidator);

				return false;

			}
		}

		return true;
	}

	protected void addErrorInformation(
			ErrorType errorType,
			int rowNumber,
			int columnNumber,
			String columnValue,
			String limitValue,
			SmartTableColumnDataValidationErrorReceiver smartTableColumnDataTypeErrorReceiver,
			ImportTableColumnConfigurable importTableColumnConfigurable,
			ImportTableColumnDataValidator importTableColumnDataValidator) {

		smartTableColumnDataTypeErrorReceiver.addTableColumnDataTypeError(
				rowNumber, columnNumber, columnValue,
				importTableColumnConfigurable, ErrorInformation
						.valueOf(importTableColumnDataValidator
								.getErrorMessageFormat(), errorType,
								importTableColumnConfigurable
										.getTableColumnName(), String
										.valueOf(rowNumber), String
										.valueOf(columnNumber), columnValue,
								limitValue));
	}
}
